/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.ais;

import aisexpert.backend.ais.AisConnection;
import aisexpert.backend.ais.AisConnectionImpl;
import aisexpert.backend.ais.AisConnectionKt;
import aisexpert.backend.ais.AisException;
import aisexpert.backend.ais.AisProperties;
import aisexpert.backend.ais.AisServiceAuthHolder;
import aisexpert.backend.ais.AnswerHandler;
import aisexpert.backend.ais.ContentType;
import aisexpert.backend.ais.Error;
import aisexpert.backend.ais.Message;
import aisexpert.backend.ais.MessageError;
import aisexpert.backend.ais.MessagePriority;
import aisexpert.backend.ais.MessageStatus;
import aisexpert.backend.ais.MessageType;
import aisexpert.backend.ais.MessageWrapper;
import aisexpert.backend.ais.WebAuthorizationCommand;
import aisexpert.backend.spring.OrdinalEnumDeserializer;
import aisexpert.backend.spring.OrdinalEnumSerializer;
import aisexpert.backend.spring.UnixOffsetDateTimeDeserializer;
import aisexpert.backend.spring.UnixOffsetDateTimeSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.KotlinModuleKt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002:\u0001VB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010+\u001a\u0004\u0018\u00010\u0019H\u0012\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u0019H\u0012J\b\u0010.\u001a\u00020\u0019H\u0012J\b\u0010/\u001a\u00020\u0019H\u0017J\u0010\u00100\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0015H\u0012J\u001a\u00101\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u000103H\u0012J\u001a\u00104\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u000103H\u0012J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0012J\u0010\u00109\u001a\u00020:2\u0006\u00107\u001a\u000208H\u0012J\u0010\u0010;\u001a\u00020<2\u0006\u00107\u001a\u000208H\u0012J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?H\u0017J:\u0010@\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0006\u0012\u0004\u0018\u0001030A2\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0B2\u0010\u0010C\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010\u001fH\u0012J\b\u0010D\u001a\u00020\fH\u0012J\u0016\u0010E\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u0001030AH\u0012J\u001c\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\f2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\fH\u0012J7\u0010H\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\f2%\u0010I\u001a!\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014j\u0002`\u001aH\u0016J$\u0010J\u001a\u00020\u00192\u0006\u0010K\u001a\u00020<2\u0006\u0010F\u001a\u00020\f2\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u0014\u0010M\u001a\u00020\u00192\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0012J\u0010\u0010N\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\fH\u0012J\b\u0010O\u001a\u00020\u0019H\u0012J\u0010\u0010P\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010Q\u001a\u00020\u0019H\u0012J\b\u0010R\u001a\u00020'H\u0012J\b\u0010S\u001a\u00020\u0019H\u0012J\u0018\u0010T\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\f2\u0006\u0010U\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R9\u0010\u0013\u001a-\u0012\u0004\u0012\u00020\f\u0012#\u0012!\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014j\u0002`\u001a0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n %*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0092.\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020 X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Laisexpert/backend/ais/AisConnectionImpl;", "Laisexpert/backend/ais/AisServiceAuthHolder;", "Laisexpert/backend/ais/AisConnection;", "properties", "Laisexpert/backend/ais/AisProperties;", "aisTaskExecutor", "Lorg/springframework/core/task/TaskExecutor;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Laisexpert/backend/ais/AisProperties;Lorg/springframework/core/task/TaskExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "answerHandlers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Laisexpert/backend/ais/AnswerHandler;", "<set-?>", "", "auth", "getAuth", "()J", "commandHandlers", "Lkotlin/Function1;", "Laisexpert/backend/ais/Message;", "Lkotlin/ParameterName;", "name", "message", "", "Laisexpert/backend/ais/CommandHandler;", "connection", "Laisexpert/backend/ais/AisConnectionImpl$Connection;", "contentTypes", "Laisexpert/backend/ais/ContentType;", "Ljava/lang/Class;", "", "enumSerializerModule", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "receiveThread", "Ljava/lang/Thread;", "running", "", "sync", "closeConnection", "()Lkotlin/Unit;", "connect", "connectionLoop", "destroy", "errorHandler", "handleAnswer", "error", "", "handleCommand", "messagePriorityOf", "Laisexpert/backend/ais/MessagePriority;", "value", "", "messageStatusOf", "Laisexpert/backend/ais/MessageStatus;", "messageTypeOf", "Laisexpert/backend/ais/MessageType;", "onRefresh", "event", "Lorg/springframework/context/event/ContextRefreshedEvent;", "parseContent", "Lkotlin/Pair;", "Laisexpert/backend/ais/MessageWrapper;", "contentClazz", "receive", "receiveMessage", "command", "expectedId", "registerCommandHandler", "handler", "registerContentType", "type", "clazz", "registerOrdinalEnumFields", "send", "sendAuthorization", "sendMessage", "sendProtocolCompatibility", "startReceiveThread", "validateSignature", "waitForAnswer", "id", "Connection", "aisexpert-backend"})
public class AisConnectionImpl
implements AisServiceAuthHolder,
AisConnection {
    private final SimpleModule enumSerializerModule;
    private final ObjectMapper objectMapper;
    private final Object sync;
    private final Logger logger;
    private Thread receiveThread;
    private volatile Connection connection;
    private volatile boolean running;
    private final ConcurrentHashMap<String, AnswerHandler> answerHandlers;
    private final ConcurrentHashMap<String, Function1<Message, Unit>> commandHandlers;
    private final ConcurrentHashMap<ContentType, Class<? extends Object>> contentTypes;
    private long auth;
    private final AisProperties properties;
    private final TaskExecutor aisTaskExecutor;

    public final long getAuth() {
        return this.auth;
    }

    @EventListener
    public void onRefresh(@NotNull ContextRefreshedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        SimpleModule simpleModule = new SimpleModule();
        ObjectMapper objectMapper = this.objectMapper;
        SimpleModule $receiver = simpleModule;
        boolean bl = false;
        $receiver.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new UnixOffsetDateTimeDeserializer());
        $receiver.addSerializer(OffsetDateTime.class, (JsonSerializer)new UnixOffsetDateTimeSerializer());
        SimpleModule simpleModule2 = simpleModule;
        objectMapper.registerModule((Module)simpleModule2);
        this.objectMapper.registerModule((Module)this.enumSerializerModule);
        this.receiveThread = this.startReceiveThread();
    }

    @PreDestroy
    public void destroy() {
        this.logger.info("Stopping connection thread...");
        this.running = false;
        this.closeConnection();
    }

    public void registerContentType(@NotNull MessageType type, @NotNull String command, @NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        ContentType contentType = new ContentType(type, command);
        if (this.contentTypes.containsKey(contentType)) {
            throw (Throwable)new RuntimeException("Content type '" + contentType + "' already registered");
        }
        Map map = this.contentTypes;
        Class<?> clazz2 = clazz;
        map.put(contentType, clazz2);
        this.registerOrdinalEnumFields(clazz);
        this.logger.info("Registered content type " + contentType + " = [" + clazz.getName() + ']');
    }

    public void registerCommandHandler(@NotNull String command, @NotNull Function1<? super Message, Unit> handler) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        if (this.commandHandlers.containsKey(command)) {
            throw (Throwable)new RuntimeException("Command handler for '" + command + "' already registered");
        }
        Map map = this.commandHandlers;
        Function1<? super Message, Unit> function1 = handler;
        map.put(command, function1);
        this.logger.info("Registered command handler for '" + command + '\'');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Message waitForAnswer(@NotNull String command, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        CompletableFuture future = new CompletableFuture();
        Map map = this.answerHandlers;
        AnswerHandler answerHandler = new AnswerHandler(command, future);
        map.put(id, answerHandler);
        try {
            Object t = future.get(this.properties.getReadTimeout(), TimeUnit.MILLISECONDS);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"future.get(properties.re\u2026t, TimeUnit.MILLISECONDS)");
            map = (Message)t;
            return map;
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable == null) {
                throwable = ex;
            }
            throw throwable;
        }
        finally {
            this.answerHandlers.remove(id);
        }
    }

    @NotNull
    public String sendMessage(@NotNull Message message) {
        String commandStr;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        int flags = 0;
        flags |= message.getType().getValue() << 0;
        flags |= MessageStatus.SUCCESS.getValue() << 3;
        flags |= message.getPriority().getValue() << 6;
        if (message.getTags() == null) {
            flags |= 0x800;
        }
        flags |= 0x1000;
        if (message.getContent() == null) {
            flags |= 0x2000;
        }
        flags |= 0x1000000;
        flags |= Integer.MIN_VALUE;
        String string = message.getId();
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
        }
        String id = string;
        String string3 = commandStr = this.objectMapper.writeValueAsString((Object)new MessageWrapper(id, message.getCommand(), (long)flags & 0xFFFFFFFFL, message.getContent(), message.getTags()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"commandStr");
        this.send(string3);
        return id;
    }

    private void registerOrdinalEnumFields(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> type;
            Field field;
            Field field2 = field = fieldArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
            if (field2.getType() == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
            }
            if (type.isEnum()) {
                this.enumSerializerModule.addSerializer(type, (JsonSerializer)new OrdinalEnumSerializer(type));
                this.enumSerializerModule.addDeserializer(type, (JsonDeserializer)new OrdinalEnumDeserializer(type));
                this.logger.info("Registered ordinal enum serializer for type [" + type.getName() + ']');
            }
            if (!KotlinModuleKt.isKotlinClass(type) || !JvmClassMappingKt.getKotlinClass(type).isData()) continue;
            this.registerOrdinalEnumFields(type);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<Message, Throwable> receiveMessage() {
        void content;
        Pair pair;
        MessagePriority priority;
        MessageType type;
        MessageWrapper message;
        block9: {
            Class<Object> contentClazz;
            block8: {
                String str = this.receive();
                Object object = this.objectMapper.readValue(str, MessageWrapper.class);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type aisexpert.backend.ais.MessageWrapper<kotlin.Any?>");
                }
                message = (MessageWrapper)object;
                int flags = (int)message.getFlags();
                type = this.messageTypeOf(flags >> 0 & 7);
                MessageStatus status = this.messageStatusOf(flags >> 3 & 7);
                priority = this.messagePriorityOf(flags >> 6 & 3);
                if (type == MessageType.UNKNOWN) {
                    throw (Throwable)new IllegalStateException("Unknown message received");
                }
                ContentType contentType = new ContentType(type, message.getCommand());
                contentClazz = (Class<Object>)this.contentTypes.get(contentType);
                if (contentClazz == null) {
                    this.logger.warn("Unknown content type '" + contentType + '\'');
                    contentClazz = Object.class;
                }
                if (type != MessageType.ANSWER) break block8;
                switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        throw (Throwable)new IllegalStateException("Unknown message status");
                    }
                    case 2: {
                        pair = this.parseContent(message, (Class)contentClazz);
                        break block9;
                    }
                    case 3: 
                    case 4: {
                        MessageError content2 = (MessageError)this.objectMapper.readValue(this.objectMapper.writeValueAsString(message.getContent()), MessageError.class);
                        pair = new Pair(null, (Object)new AisException(content2.getGroup(), content2.getCode(), content2.getDescription()));
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            pair = this.parseContent(message, (Class)contentClazz);
        }
        Pair pair2 = pair;
        Object object = pair2.component1();
        Throwable error = (Throwable)pair2.component2();
        return new Pair((Object)new Message(message.getId(), type, message.getCommand(), (Object)content, priority, message.getTags()), (Object)error);
    }

    private Pair<Object, Throwable> parseContent(MessageWrapper<Object> message, Class<? extends Object> contentClazz) {
        Pair pair;
        try {
            pair = new Pair(this.objectMapper.readValue(this.objectMapper.writeValueAsString(message.getContent()), contentClazz), null);
        }
        catch (Throwable ex) {
            pair = new Pair(null, (Object)ex);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(String message) {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            Object object2 = this.connection;
            if (object2 == null || (object2 = object2.getOutput()) == null) {
                throw (Throwable)new SocketException("AIS Connection not available");
            }
            Object output = object2;
            this.logger.info("Sending message: " + message);
            String string = message;
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] messageBytes = byArray;
            ((DataOutputStream)output).writeInt(messageBytes.length);
            ((FilterOutputStream)output).write(messageBytes);
            ((DataOutputStream)output).flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    private String receive() {
        Object object = this.connection;
        if (object == null || (object = object.getInput()) == null) {
            throw (Throwable)new SocketException("AIS Connection not available");
        }
        Object input = object;
        int len = ((DataInputStream)input).readInt();
        byte[] bytes = new byte[len];
        for (int offset = 0; offset < len; offset += ((DataInputStream)input).read(bytes, offset, len - offset)) {
        }
        byte[] byArray = bytes;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        String message = new String(byArray, charset2);
        this.logger.info("Received message: " + message);
        return message;
    }

    /*
     * WARNING - void declaration
     */
    private Message receiveMessage(String command, String expectedId) {
        void answerMessage;
        Pair pair = this.receiveMessage();
        Message message = (Message)pair.component1();
        Throwable error = (Throwable)pair.component2();
        if (error != null) {
            throw error;
        }
        if (Intrinsics.areEqual((Object)answerMessage.getCommand(), (Object)command) ^ true) {
            throw (Throwable)new IllegalStateException("Received message with unexpected command field" + '(' + command + " != " + answerMessage.getCommand() + ", id = " + expectedId);
        }
        if (expectedId != null && Intrinsics.areEqual((Object)answerMessage.getId(), (Object)expectedId) ^ true) {
            throw (Throwable)new IllegalStateException("Received message with unexpected id field (" + expectedId + " != " + answerMessage.getId() + ')');
        }
        return answerMessage;
    }

    static /* synthetic */ Message receiveMessage$default(AisConnectionImpl aisConnectionImpl, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: receiveMessage");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return aisConnectionImpl.receiveMessage(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private void validateSignature() {
        void input;
        this.logger.info("Validating signature...");
        Connection connection = this.connection;
        if (connection == null) {
            throw (Throwable)new SocketException("AIS Connection not available");
        }
        Connection connection2 = connection;
        DataInputStream dataInputStream = connection2.component2();
        DataOutputStream output = connection2.component3();
        output.writeLong(AisConnectionKt.getPROTOCOL_SIGNATURE().getMostSignificantBits());
        output.writeLong(AisConnectionKt.getPROTOCOL_SIGNATURE().getLeastSignificantBits());
        output.flush();
        long mostBits = input.readLong();
        long leastBits = input.readLong();
        UUID receivedSignature = new UUID(mostBits, leastBits);
        if (Intrinsics.areEqual((Object)receivedSignature, (Object)AisConnectionKt.getPROTOCOL_SIGNATURE()) ^ true) {
            throw (Throwable)new RuntimeException("Protocol signatures didn't match (" + AisConnectionKt.getPROTOCOL_SIGNATURE() + " != " + receivedSignature + ')');
        }
    }

    private void sendProtocolCompatibility() {
        this.logger.info("Sending ProtocolCompatible message...");
        this.sendMessage(new Message(null, MessageType.COMMAND, "173cbbeb-1d81-4e01-bf3c-5d06f9c878c3", null, null, null, 57, null));
        AisConnectionImpl.receiveMessage$default((AisConnectionImpl)this, (String)"173cbbeb-1d81-4e01-bf3c-5d06f9c878c3", null, (int)2, null);
    }

    private void sendAuthorization() {
        this.logger.info("Sending WebAuthorization message...");
        this.sendMessage(new Message(null, MessageType.COMMAND, "7bd4b1c1-3f8f-4bcf-b941-5a0f1e7b449f", (Object)new WebAuthorizationCommand(this.properties.getPassword()), null, null, 49, null));
        Message message = AisConnectionImpl.receiveMessage$default((AisConnectionImpl)this, (String)"7bd4b1c1-3f8f-4bcf-b941-5a0f1e7b449f", null, (int)2, null);
        Object object = message.getTags();
        if (object == null || (object = (Long)object.get(0)) == null) {
            throw (Throwable)new RuntimeException("Failed service authentication");
        }
        this.auth = (Long)object;
        this.logger.info("Protocol initialization completed");
    }

    private MessageType messageTypeOf(int value) {
        MessageType messageType;
        int n = value;
        if (n == MessageType.UNKNOWN.getValue()) {
            messageType = MessageType.UNKNOWN;
        } else if (n == MessageType.COMMAND.getValue()) {
            messageType = MessageType.COMMAND;
        } else if (n == MessageType.ANSWER.getValue()) {
            messageType = MessageType.ANSWER;
        } else if (n == MessageType.EVENT.getValue()) {
            messageType = MessageType.EVENT;
        } else {
            throw (Throwable)new IllegalStateException("Unknown message type " + value);
        }
        return messageType;
    }

    private MessageStatus messageStatusOf(int value) {
        MessageStatus messageStatus;
        int n = value;
        if (n == MessageStatus.UNKNOWN.getValue()) {
            messageStatus = MessageStatus.UNKNOWN;
        } else if (n == MessageStatus.SUCCESS.getValue()) {
            messageStatus = MessageStatus.SUCCESS;
        } else if (n == MessageStatus.FAILED.getValue()) {
            messageStatus = MessageStatus.FAILED;
        } else if (n == MessageStatus.ERROR.getValue()) {
            messageStatus = MessageStatus.ERROR;
        } else {
            throw (Throwable)new IllegalStateException("Unknown message status " + value);
        }
        return messageStatus;
    }

    private MessagePriority messagePriorityOf(int value) {
        MessagePriority messagePriority;
        int n = value;
        if (n == MessagePriority.HIGH.getValue()) {
            messagePriority = MessagePriority.HIGH;
        } else if (n == MessagePriority.NORMAL.getValue()) {
            messagePriority = MessagePriority.NORMAL;
        } else if (n == MessagePriority.LOW.getValue()) {
            messagePriority = MessagePriority.LOW;
        } else {
            throw (Throwable)new IllegalStateException("Unknown message priority " + value);
        }
        return messagePriority;
    }

    private Thread startReceiveThread() {
        return ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"ais-thread", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)23, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit closeConnection() {
        Unit unit;
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            try {
                Unit unit2;
                Object object2 = this.connection;
                if (object2 != null && (object2 = object2.getSocket()) != null) {
                    ((Socket)object2).close();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (Throwable ex) {
                this.logger.error("Error while closing connection", ex);
                unit = Unit.INSTANCE;
            }
            finally {
                this.connection = null;
            }
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private void connectionLoop() {
        while (true) {
            void message;
            Pair pair = this.receiveMessage();
            Message message2 = (Message)pair.component1();
            Throwable error = (Throwable)pair.component2();
            if (message.getType() == MessageType.ANSWER) {
                this.handleAnswer((Message)message, error);
                continue;
            }
            if (message.getType() == MessageType.COMMAND || message.getType() == MessageType.EVENT) {
                this.handleCommand((Message)message, error);
                continue;
            }
            this.logger.error("Cannot handle message with type " + message.getType(), error);
        }
    }

    private void connect() {
        this.logger.info("Connecting to " + this.properties.getHost() + ':' + this.properties.getPort() + "...");
        Socket socket = new Socket(this.properties.getHost(), this.properties.getPort());
        DataInputStream input = new DataInputStream(socket.getInputStream());
        DataOutputStream output = new DataOutputStream(socket.getOutputStream());
        this.logger.info("Connected");
        this.connection = new Connection(socket, input, output);
    }

    private void handleAnswer(Message message, Throwable error) {
        try {
            Map map = this.answerHandlers;
            String string = message.getId();
            AnswerHandler answerHandler = (AnswerHandler)map.get(string);
            if (answerHandler == null) {
                return;
            }
            AnswerHandler handler = answerHandler;
            if (error != null) {
                handler.getHandler().completeExceptionally(error);
            } else {
                handler.getHandler().complete(message);
            }
        }
        catch (Throwable ex) {
            this.logger.error("Error in answer handler", ex);
        }
    }

    private void handleCommand(Message message, Throwable error) {
        if (error != null) {
            this.logger.error("Error receiving message", error);
            return;
        }
        this.aisTaskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void errorHandler(Message message) {
        try {
            Object object = message.getContent();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type aisexpert.backend.ais.Error");
            }
            Error error = (Error)object;
            AnswerHandler answerHandler = (AnswerHandler)this.answerHandlers.get(error.getMessageId());
            if (answerHandler == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)answerHandler, (String)"answerHandlers[error.messageId] ?: return");
            AnswerHandler handler = answerHandler;
            handler.getHandler().completeExceptionally(new RuntimeException(error.getDescription()));
        }
        catch (Throwable ex) {
            this.logger.error("Error in answer handler", ex);
        }
    }

    public AisConnectionImpl(@NotNull AisProperties properties, @NotNull TaskExecutor aisTaskExecutor, @NotNull ObjectMapper objectMapper) {
        ConcurrentHashMap<String, commandHandlers.1.1> concurrentHashMap;
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)aisTaskExecutor, (String)"aisTaskExecutor");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        this.properties = properties;
        this.aisTaskExecutor = aisTaskExecutor;
        this.enumSerializerModule = new SimpleModule();
        this.objectMapper = objectMapper.copy();
        this.sync = new Object();
        this.logger = LoggerFactory.getLogger(AisConnectionImpl.class);
        this.running = true;
        this.answerHandlers = new ConcurrentHashMap();
        ConcurrentHashMap<String, commandHandlers.1.1> concurrentHashMap2 = new ConcurrentHashMap<String, commandHandlers.1.1>();
        AisConnectionImpl aisConnectionImpl = this;
        ConcurrentHashMap<String, commandHandlers.1.1> it = concurrentHashMap2;
        boolean bl = false;
        it.put("b18b98cc-b026-4bfe-8e33-e7afebfbe78b", new commandHandlers.1.1(this));
        aisConnectionImpl.commandHandlers = concurrentHashMap = concurrentHashMap2;
        this.contentTypes = new ConcurrentHashMap(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)new ContentType(MessageType.COMMAND, "173cbbeb-1d81-4e01-bf3c-5d06f9c878c3"), Object.class), TuplesKt.to((Object)new ContentType(MessageType.COMMAND, "b18b98cc-b026-4bfe-8e33-e7afebfbe78b"), Error.class)}));
    }

    public static final /* synthetic */ Logger access$getLogger$p(AisConnectionImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AisProperties access$getProperties$p(AisConnectionImpl $this) {
        return $this.properties;
    }

    public static final /* synthetic */ boolean access$getRunning$p(AisConnectionImpl $this) {
        return $this.running;
    }

    public static final /* synthetic */ void access$setRunning$p(AisConnectionImpl $this, boolean bl) {
        $this.running = bl;
    }

    public static final /* synthetic */ void access$connect(AisConnectionImpl $this) {
        $this.connect();
    }

    public static final /* synthetic */ Connection access$getConnection$p(AisConnectionImpl $this) {
        return $this.connection;
    }

    public static final /* synthetic */ void access$setConnection$p(AisConnectionImpl $this, Connection connection) {
        $this.connection = connection;
    }

    public static final /* synthetic */ void access$validateSignature(AisConnectionImpl $this) {
        $this.validateSignature();
    }

    public static final /* synthetic */ void access$sendProtocolCompatibility(AisConnectionImpl $this) {
        $this.sendProtocolCompatibility();
    }

    public static final /* synthetic */ void access$sendAuthorization(AisConnectionImpl $this) {
        $this.sendAuthorization();
    }

    public static final /* synthetic */ void access$connectionLoop(AisConnectionImpl $this) {
        $this.connectionLoop();
    }

    public static final /* synthetic */ Unit access$closeConnection(AisConnectionImpl $this) {
        return $this.closeConnection();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCommandHandlers$p(AisConnectionImpl $this) {
        return $this.commandHandlers;
    }

    public static final /* synthetic */ void access$errorHandler(AisConnectionImpl $this, Message message) {
        $this.errorHandler(message);
    }
}

