/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.spring;

import aisexpert.backend.ais.AisException;
import aisexpert.backend.spring.AisExceptionHandlerKt;
import aisexpert.backend.spring.ErrorBody;
import aisexpert.backend.web.HttpException;
import java.net.SocketException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u000bH\u0017J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\fH\u0017J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\rH\u0017J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u000eH\u0016J6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Laisexpert/backend/spring/AisExceptionHandler;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handle", "Lorg/springframework/http/ResponseEntity;", "Laisexpert/backend/spring/ErrorBody;", "ex", "Laisexpert/backend/ais/AisException;", "Laisexpert/backend/web/HttpException;", "Ljava/net/SocketException;", "Ljava/util/concurrent/TimeoutException;", "", "httpError", "status", "Lorg/springframework/http/HttpStatus;", "group", "", "code", "", "message", "aisexpert-backend"})
public class AisExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(AisExceptionHandler.class);

    @ExceptionHandler(value={AisException.class})
    @NotNull
    public ResponseEntity<ErrorBody> handle(@NotNull AisException ex) {
        HttpStatus httpStatus;
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        if (AisExceptionHandlerKt.access$getCriticalErrorGroups$p().contains(ex.getGroup())) {
            this.logger.error("Unknown AIS error", (Throwable)ex);
            httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        } else {
            httpStatus = HttpStatus.BAD_REQUEST;
        }
        HttpStatus status = httpStatus;
        return this.httpError(status, ex.getGroup(), ex.getCode(), ex.getMessage());
    }

    @ExceptionHandler(value={HttpException.class})
    @NotNull
    public ResponseEntity<ErrorBody> handle(@NotNull HttpException ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        return this.httpError(ex.getStatus(), ex.getGroup(), ex.getCode(), ex.getMessage());
    }

    @ExceptionHandler(value={SocketException.class})
    @NotNull
    public ResponseEntity<ErrorBody> handle(@NotNull SocketException ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        return AisExceptionHandler.httpError$default((AisExceptionHandler)this, (HttpStatus)HttpStatus.SERVICE_UNAVAILABLE, (int)0, null, null, (int)14, null);
    }

    @ExceptionHandler(value={TimeoutException.class})
    @NotNull
    public ResponseEntity<ErrorBody> handle(@NotNull TimeoutException ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        return AisExceptionHandler.httpError$default((AisExceptionHandler)this, (HttpStatus)HttpStatus.REQUEST_TIMEOUT, (int)0, null, null, (int)14, null);
    }

    @NotNull
    public ResponseEntity<ErrorBody> handle(@NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        Throwable throwable = ex;
        return throwable instanceof AisException ? this.handle((AisException)ex) : (throwable instanceof HttpException ? this.handle((HttpException)ex) : (throwable instanceof SocketException ? this.handle((SocketException)ex) : (throwable instanceof TimeoutException ? this.handle((TimeoutException)ex) : AisExceptionHandler.httpError$default((AisExceptionHandler)this, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (int)0, null, null, (int)14, null))));
    }

    private ResponseEntity<ErrorBody> httpError(HttpStatus status, int group, String code, String message) {
        String string = message;
        if (string == null) {
            string = status.getReasonPhrase();
        }
        return new ResponseEntity((Object)new ErrorBody(group, code, string), status);
    }

    static /* synthetic */ ResponseEntity httpError$default(AisExceptionHandler aisExceptionHandler, HttpStatus httpStatus, int n, String string, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: httpError");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            string = "";
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        return aisExceptionHandler.httpError(httpStatus, n, string, string2);
    }
}

