/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.spring;

import aisexpert.backend.ais.AisConnection;
import aisexpert.backend.ais.MessageType;
import aisexpert.backend.spring.AisCommandHandler;
import aisexpert.backend.spring.AisEventHandler;
import aisexpert.backend.spring.AisListener;
import aisexpert.backend.spring.UtilsKt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bH\u0016J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0012R2\u0010\u0006\u001a&\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007j\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t`\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Laisexpert/backend/spring/AisListenerBeanPostProcessor;", "Lorg/springframework/core/Ordered;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "connection", "Laisexpert/backend/ais/AisConnection;", "(Laisexpert/backend/ais/AisConnection;)V", "beans", "Ljava/util/HashMap;", "", "Ljava/lang/Class;", "Lkotlin/collections/HashMap;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getOrder", "", "postProcessAfterInitialization", "", "bean", "beanName", "postProcessBeforeInitialization", "registerMethod", "", "method", "Ljava/lang/reflect/Method;", "commandType", "messageType", "Laisexpert/backend/ais/MessageType;", "aisexpert-backend"})
public class AisListenerBeanPostProcessor
implements Ordered,
BeanPostProcessor {
    private final Logger logger;
    private final HashMap<String, Class<?>> beans;
    private final AisConnection connection;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        Intrinsics.checkParameterIsNotNull((Object)beanName, (String)"beanName");
        Class<?> clazz = bean.getClass();
        if (clazz.isAnnotationPresent(AisListener.class)) {
            Map map = this.beans;
            Class<?> clazz2 = clazz;
            map.put(beanName, clazz2);
        }
        return bean;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        AisCommandHandler annotation;
        void $receiver$iv$iv;
        void $receiver$iv;
        int n;
        Method[] $receiver$iv$iv2;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        Intrinsics.checkParameterIsNotNull((Object)beanName, (String)"beanName");
        Class clazz = (Class)this.beans.get(beanName);
        if (clazz == null) {
            return bean;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"beans[beanName] ?: return bean");
        Class clazz2 = clazz;
        Method[] methodArray = clazz2.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"clazz.methods");
        Method[] methodArray2 = methodArray;
        void var6_5 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        void var8_7 = $receiver$iv$iv2;
        int n2 = ((void)var8_7).length;
        for (n = 0; n < n2; ++n) {
            void element$iv$iv;
            void it = element$iv$iv = var8_7[n];
            boolean bl = false;
            if (!it.isAnnotationPresent(AisCommandHandler.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List commandMethods = (List)destination$iv$iv;
        Method[] methodArray3 = clazz2.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray3, (String)"clazz.methods");
        $receiver$iv$iv2 = methodArray3;
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        void var9_9 = $receiver$iv$iv;
        n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var9_9[i];
            boolean bl = false;
            if (!it.isAnnotationPresent(AisEventHandler.class)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List eventMethods = (List)destination$iv$iv2;
        this.logger.info("Found AIS listener [" + clazz2.getName() + ']');
        for (Method method : commandMethods) {
            annotation = method.getAnnotation(AisCommandHandler.class);
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            this.registerMethod(bean, method2, annotation.type(), MessageType.COMMAND);
            this.logger.info("Command handler registered [" + method + ']');
        }
        for (Method method : eventMethods) {
            annotation = method.getAnnotation(AisEventHandler.class);
            Method method3 = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"method");
            this.registerMethod(bean, method3, annotation.type(), MessageType.EVENT);
            this.logger.info("Event handler registered [" + method + ']');
        }
        return bean;
    }

    private void registerMethod(Object bean, Method method, String commandType, MessageType messageType) {
        Integer tagIndex = UtilsKt.aisTagIndex((Method)method);
        Integer commandIndex = UtilsKt.aisCommandIndex((Method)method);
        if (commandIndex != null) {
            Class<?> clazz = method.getParameterTypes()[commandIndex];
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"method.parameterTypes[commandIndex]");
            this.connection.registerContentType(messageType, commandType, clazz);
        }
        if (messageType == MessageType.COMMAND && Intrinsics.areEqual(method.getReturnType(), Void.TYPE) ^ true) {
            Class<?> clazz = method.getReturnType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"method.returnType");
            this.connection.registerContentType(MessageType.ANSWER, commandType, clazz);
        }
        this.connection.registerCommandHandler(commandType, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public AisListenerBeanPostProcessor(@NotNull AisConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        this.connection = connection;
        this.logger = LoggerFactory.getLogger(AisListenerBeanPostProcessor.class);
        this.beans = new HashMap();
    }

    public static final /* synthetic */ AisConnection access$getConnection$p(AisListenerBeanPostProcessor $this) {
        return $this.connection;
    }
}

