/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.spring;

import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.UserActivityService;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Laisexpert/backend/spring/UserActivityHandlerInterceptor;", "Lorg/springframework/web/servlet/handler/HandlerInterceptorAdapter;", "userActivityService", "Laisexpert/backend/web/UserActivityService;", "(Laisexpert/backend/web/UserActivityService;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "postHandle", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "handler", "", "modelAndView", "Lorg/springframework/web/servlet/ModelAndView;", "aisexpert-backend"})
public final class UserActivityHandlerInterceptor
extends HandlerInterceptorAdapter {
    private final Logger logger;
    private final UserActivityService userActivityService;

    public void postHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, @Nullable ModelAndView modelAndView) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        try {
            Principal principal = request.getUserPrincipal();
            if (!(principal instanceof AuthToken)) {
                principal = null;
            }
            AuthToken authToken = (AuthToken)principal;
            if (authToken == null) {
                return;
            }
            AuthToken principal2 = authToken;
            this.userActivityService.updateActivityByTokenSecret(CollectionsKt.listOf((Object)principal2.getSecret()));
        }
        catch (Throwable ex) {
            this.logger.error("Unexpected error in postHandle", ex);
        }
    }

    public UserActivityHandlerInterceptor(@NotNull UserActivityService userActivityService) {
        Intrinsics.checkParameterIsNotNull((Object)userActivityService, (String)"userActivityService");
        this.userActivityService = userActivityService;
        this.logger = LoggerFactory.getLogger(UserActivityHandlerInterceptor.class);
    }
}

