/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.spring;

import aisexpert.backend.repository.AuthTokenRepository;
import aisexpert.backend.spring.Http401UnauthorizedEntryPoint;
import aisexpert.backend.spring.WebSecurityTokenFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Laisexpert/backend/spring/WebSecurityConfig;", "Lorg/springframework/security/config/annotation/web/configuration/WebSecurityConfigurerAdapter;", "authTokenRepository", "Laisexpert/backend/repository/AuthTokenRepository;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Laisexpert/backend/repository/AuthTokenRepository;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "configure", "", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "aisexpert-backend"})
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final AuthTokenRepository authTokenRepository;
    private final ObjectMapper objectMapper;

    protected void configure(@NotNull HttpSecurity http) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        http.csrf().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.addFilterBefore((Filter)new WebSecurityTokenFilter(this.authTokenRepository, this.objectMapper), UsernamePasswordAuthenticationFilter.class);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/api/auth/login"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().anyRequest()).permitAll();
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new Http401UnauthorizedEntryPoint(this.objectMapper));
    }

    public WebSecurityConfig(@NotNull AuthTokenRepository authTokenRepository, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)authTokenRepository, (String)"authTokenRepository");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        this.authTokenRepository = authTokenRepository;
        this.objectMapper = objectMapper;
    }
}

