/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.spring;

import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.repository.AuthTokenRepository;
import aisexpert.backend.spring.ErrorBody;
import aisexpert.backend.spring.UtilsKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Laisexpert/backend/spring/WebSecurityTokenFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "authTokenRepository", "Laisexpert/backend/repository/AuthTokenRepository;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Laisexpert/backend/repository/AuthTokenRepository;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "doFilterInternal", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "filterChain", "Ljavax/servlet/FilterChain;", "aisexpert-backend"})
public final class WebSecurityTokenFilter
extends OncePerRequestFilter {
    private final AuthTokenRepository authTokenRepository;
    private final ObjectMapper objectMapper;

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)filterChain, (String)"filterChain");
        String header = request.getHeader("Authorization");
        String string = header;
        if (string == null) {
            string = header = request.getParameter("auth-token");
        }
        if (header == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!StringsKt.startsWith$default((String)header, (String)"Bearer ", (boolean)false, (int)2, null)) {
            response.setStatus(400);
            UtilsKt.writeJson((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (Object)new ErrorBody(0, "", "Authorization token format must be 'Bearer <token>'"));
            return;
        }
        String secret = StringsKt.replace$default((String)header, (String)"Bearer ", (String)"", (boolean)false, (int)4, null);
        AuthToken token = this.authTokenRepository.findById((Object)secret).orElse(null);
        if (token == null) {
            response.setStatus(403);
            UtilsKt.writeJson((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (Object)new ErrorBody(0, "", "Authorization token not found"));
            return;
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        securityContext.setAuthentication((Authentication)token);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public WebSecurityTokenFilter(@NotNull AuthTokenRepository authTokenRepository, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)authTokenRepository, (String)"authTokenRepository");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        this.authTokenRepository = authTokenRepository;
        this.objectMapper = objectMapper;
    }
}

