/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.spring;

import aisexpert.backend.web.WebSocketRegistry;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Laisexpert/backend/spring/WebSocketRegistryImpl;", "Laisexpert/backend/web/WebSocketRegistry;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sessions", "Ljava/util/ArrayList;", "Lorg/springframework/web/socket/WebSocketSession;", "Lkotlin/collections/ArrayList;", "afterConnectionClosed", "", "session", "closeStatus", "Lorg/springframework/web/socket/CloseStatus;", "afterConnectionEstablished", "disconnectByPrincipal", "principal", "Ljava/security/Principal;", "aisexpert-backend"})
public class WebSocketRegistryImpl
implements WebSocketRegistry {
    private final Logger logger = LoggerFactory.getLogger(WebSocketRegistryImpl.class);
    private final ArrayList<WebSocketSession> sessions = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionEstablished(@NotNull WebSocketSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.logger.info("WebSocket connected, session = " + session);
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus closeStatus) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)closeStatus, (String)"closeStatus");
        this.logger.info("WebSocket disconnected, session = " + session);
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void disconnectByPrincipal(@NotNull Principal principal) {
        Intrinsics.checkParameterIsNotNull((Object)principal, (String)"principal");
        this.logger.info("Closing sessions by principal = " + principal);
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            void $receiver$iv$iv;
            boolean bl = false;
            Iterable $receiver$iv = this.sessions;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                WebSocketSession it = (WebSocketSession)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getPrincipal(), (Object)principal)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List forDisconnect = (List)destination$iv$iv;
            $receiver$iv = forDisconnect;
            for (Object element$iv : $receiver$iv) {
                WebSocketSession it = (WebSocketSession)element$iv;
                boolean bl3 = false;
                it.close(CloseStatus.SESSION_NOT_RELIABLE);
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

