/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisUserService;
import aisexpert.backend.ais.UserAuthAnswer;
import aisexpert.backend.ais.UserAuthCommand;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.repository.AuthTokenRepository;
import aisexpert.backend.spring.AisCommandHandler;
import aisexpert.backend.spring.AisListener;
import aisexpert.backend.spring.AisTag;
import aisexpert.backend.web.AuthTokenDto;
import aisexpert.backend.web.RevokeAuthTokenDto;
import aisexpert.backend.web.UserLoginRequest;
import aisexpert.backend.web.UserLoginResponse;
import aisexpert.backend.web.WebSocketRegistry;
import java.security.Principal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
@AisListener
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0012\u0010\u0013\u001a\u00020\u00102\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u000b\u001a\u00020\u0017H\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Laisexpert/backend/web/AuthController;", "", "aisUserService", "Laisexpert/backend/ais/AisUserService;", "authTokenRepository", "Laisexpert/backend/repository/AuthTokenRepository;", "webSocketRegistry", "Laisexpert/backend/web/WebSocketRegistry;", "(Laisexpert/backend/ais/AisUserService;Laisexpert/backend/repository/AuthTokenRepository;Laisexpert/backend/web/WebSocketRegistry;)V", "login", "Laisexpert/backend/web/UserLoginResponse;", "data", "Laisexpert/backend/web/UserLoginRequest;", "request", "Ljavax/servlet/http/HttpServletRequest;", "logout", "", "authToken", "Laisexpert/backend/entity/AuthToken;", "resetUserAuth", "hashId", "", "revoke", "Laisexpert/backend/web/RevokeAuthTokenDto;", "tokens", "", "Laisexpert/backend/web/AuthTokenDto;", "aisexpert-backend"})
public class AuthController {
    private final AisUserService aisUserService;
    private final AuthTokenRepository authTokenRepository;
    private final WebSocketRegistry webSocketRegistry;

    @PostMapping(value={"/login"})
    @Transactional
    @NotNull
    public UserLoginResponse login(@RequestBody @NotNull UserLoginRequest data, @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        UserAuthAnswer authAnswer = this.aisUserService.userAuth(new UserAuthCommand(data.getLogin(), data.getPassword(), null, null, null, 0L, false, 124, null));
        if (data.getRemoveOldTokens()) {
            List tokens = this.authTokenRepository.findByHashId(authAnswer.getHashId());
            Iterable $receiver$iv = tokens;
            for (Object element$iv : $receiver$iv) {
                AuthToken it = (AuthToken)element$iv;
                boolean bl = false;
                this.webSocketRegistry.disconnectByPrincipal((Principal)it);
            }
            this.authTokenRepository.deleteAll((Iterable)tokens);
        }
        OffsetDateTime now = OffsetDateTime.now();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        AuthToken token = new AuthToken(string, authAnswer.getId(), data.getLogin(), authAnswer.getHashId(), Boolean.valueOf(authAnswer.isAdmin()), request.getHeader("User-Agent"), request.getRemoteAddr(), now, now);
        this.authTokenRepository.save((Object)token);
        return new UserLoginResponse("Bearer " + token.getSecret());
    }

    @PostMapping(value={"/logout"})
    public void logout(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        this.aisUserService.userLogout(authToken.getHashId());
        this.authTokenRepository.delete((Object)authToken);
        this.webSocketRegistry.disconnectByPrincipal((Principal)authToken);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/tokens"})
    @NotNull
    public List<AuthTokenDto> tokens(@NotNull AuthToken authToken) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Iterable iterable = $receiver$iv = (Iterable)this.authTokenRepository.findByHashId(authToken.getHashId());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            AuthToken authToken2 = (AuthToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AuthTokenDto authTokenDto = new AuthTokenDto(it.getSecret(), it.getUserAgent(), it.getClientIp(), it.getCreatedAt(), it.getLastActive());
            collection.add(authTokenDto);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/tokens/revoke"})
    @Transactional
    public void revoke(@NotNull AuthToken authToken, @RequestBody @NotNull RevokeAuthTokenDto data) {
        void $receiver$iv;
        Iterable tokens;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Iterable iterable = this.authTokenRepository.findAllById((Iterable)data.getSecrets());
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"authTokenRepository.findAllById(data.secrets)");
        Iterable iterable2 = tokens = iterable;
        AuthController authController = this;
        for (Object element$iv : $receiver$iv) {
            AuthToken p1 = (AuthToken)element$iv;
            boolean bl = false;
            authController.logout(p1);
        }
    }

    @AisCommandHandler(type="14c292a9-5e92-4c8d-8f61-ba3658254754")
    @Transactional
    public void resetUserAuth(@AisTag long hashId) {
        for (AuthToken token : this.authTokenRepository.findByHashId(hashId)) {
            this.webSocketRegistry.disconnectByPrincipal((Principal)token);
        }
        this.authTokenRepository.deleteByHashId(hashId);
    }

    public AuthController(@NotNull AisUserService aisUserService, @NotNull AuthTokenRepository authTokenRepository, @NotNull WebSocketRegistry webSocketRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)aisUserService, (String)"aisUserService");
        Intrinsics.checkParameterIsNotNull((Object)authTokenRepository, (String)"authTokenRepository");
        Intrinsics.checkParameterIsNotNull((Object)webSocketRegistry, (String)"webSocketRegistry");
        this.aisUserService = aisUserService;
        this.authTokenRepository = authTokenRepository;
        this.webSocketRegistry = webSocketRegistry;
    }
}

