/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisSyncDataService;
import aisexpert.backend.ais.AisTaskService;
import aisexpert.backend.ais.SyncDataDto;
import aisexpert.backend.ais.SyncDataEditCommand;
import aisexpert.backend.ais.TaskExecStatus;
import aisexpert.backend.ais.TaskInterruptCommand;
import aisexpert.backend.ais.TaskType;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.DataSyncUpdateDto;
import aisexpert.backend.web.DataSyncWrapperDto;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/data-sync"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\f\u0010\u0011\u001a\u00020\b*\u00020\u0012H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Laisexpert/backend/web/DataSyncController;", "", "aisSyncDataService", "Laisexpert/backend/ais/AisSyncDataService;", "aisTaskService", "Laisexpert/backend/ais/AisTaskService;", "(Laisexpert/backend/ais/AisSyncDataService;Laisexpert/backend/ais/AisTaskService;)V", "info", "Laisexpert/backend/web/DataSyncWrapperDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "interrupt", "", "syncNow", "update", "data", "Laisexpert/backend/web/DataSyncUpdateDto;", "toWrapper", "Laisexpert/backend/ais/SyncDataDto;", "aisexpert-backend"})
public class DataSyncController {
    private final AisSyncDataService aisSyncDataService;
    private final AisTaskService aisTaskService;

    @GetMapping
    @NotNull
    public DataSyncWrapperDto info(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        SyncDataDto inner = this.aisSyncDataService.info(authToken.getHashId());
        return this.toWrapper(inner);
    }

    @PatchMapping
    @NotNull
    public DataSyncWrapperDto update(@NotNull AuthToken authToken, @RequestBody @NotNull DataSyncUpdateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        SyncDataDto info = this.aisSyncDataService.info(authToken.getHashId());
        Boolean bl = data.isEnabled();
        boolean bl2 = bl != null ? bl.booleanValue() : info.isEnabled();
        OffsetDateTime offsetDateTime = data.getNextDateTime();
        if (offsetDateTime == null) {
            offsetDateTime = info.getNextDateTime();
        }
        Integer n = data.getAttemptInterval();
        Integer n2 = data.getAttemptLimit();
        Short s = data.getPeriodDuration();
        short s2 = 0;
        short s3 = 0;
        int n3 = s != null ? s.shortValue() : info.getRelPeriodDuration();
        int n4 = 0;
        int n5 = n2 != null ? n2.intValue() : info.getAttemptLimit();
        int n6 = n != null ? n.intValue() : info.getAttemptInterval();
        info = SyncDataDto.copy$default((SyncDataDto)info, null, (boolean)bl2, null, (OffsetDateTime)offsetDateTime, null, (int)n5, (int)n6, (short)n4, (short)n3, (int)s3, (int)s2, (int)1557, null);
        s2 = info.getRelPeriodDuration();
        s3 = info.getRelPeriodBegin();
        n3 = info.getAttemptLimit();
        n4 = info.getAttemptInterval();
        OffsetDateTime offsetDateTime2 = info.getNextDateTime();
        OffsetDateTime offsetDateTime3 = info.getRunDateTime();
        this.aisSyncDataService.edit(authToken.getHashId(), new SyncDataEditCommand(info.isEnabled(), offsetDateTime2, offsetDateTime3, n3, n4, s3, s2));
        return this.toWrapper(info);
    }

    @PostMapping(value={"/now"})
    public void syncNow(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        this.aisSyncDataService.now(authToken.getHashId());
    }

    @PostMapping(value={"/interrupt"})
    public void interrupt(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        SyncDataDto task = this.aisSyncDataService.info(authToken.getHashId());
        this.aisTaskService.interrupt(authToken.getHashId(), new TaskInterruptCommand(task.getTaskId(), TaskType.SYNC_DATA, authToken.getUserId()));
    }

    private DataSyncWrapperDto toWrapper(@NotNull SyncDataDto $receiver) {
        int n = $receiver.getTotal();
        int n2 = $receiver.getCurrent();
        TaskExecStatus taskExecStatus = $receiver.getTaskExecStatus();
        OffsetDateTime offsetDateTime = $receiver.getRunDateTime();
        short s = $receiver.getRelPeriodDuration();
        OffsetDateTime offsetDateTime2 = $receiver.getNextDateTime();
        int n3 = $receiver.getAttemptLimit();
        int n4 = $receiver.getAttemptInterval();
        return new DataSyncWrapperDto($receiver.getTaskId(), $receiver.isEnabled(), offsetDateTime, offsetDateTime2, taskExecStatus, n3, n4, s, n2, n);
    }

    public DataSyncController(@NotNull AisSyncDataService aisSyncDataService, @NotNull AisTaskService aisTaskService) {
        Intrinsics.checkParameterIsNotNull((Object)aisSyncDataService, (String)"aisSyncDataService");
        Intrinsics.checkParameterIsNotNull((Object)aisTaskService, (String)"aisTaskService");
        this.aisSyncDataService = aisSyncDataService;
        this.aisTaskService = aisTaskService;
    }
}

