/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisNotifyAddressService;
import aisexpert.backend.ais.AisNotifyTriggerService;
import aisexpert.backend.ais.NotifyAddressCreateCommand;
import aisexpert.backend.ais.NotifyAddressDto;
import aisexpert.backend.ais.NotifyAddressInfoCommand;
import aisexpert.backend.ais.NotifyAddressListCommand;
import aisexpert.backend.ais.NotifyTriggerCreateCommand;
import aisexpert.backend.ais.NotifyTriggerDto;
import aisexpert.backend.ais.NotifyTriggerInfoCommand;
import aisexpert.backend.ais.NotifyTriggerListCommand;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.BatchResult;
import aisexpert.backend.web.BatchUpdate;
import aisexpert.backend.web.BatchUpdateService;
import aisexpert.backend.web.NotifyAddressCreateDto;
import aisexpert.backend.web.NotifyAddressUpdateDto;
import aisexpert.backend.web.NotifyTriggerCreateDto;
import aisexpert.backend.web.NotifyTriggerUpdateDto;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notify"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u0011H\u0017J\u001a\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u001a\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0017J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0017J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Laisexpert/backend/web/NotifyController;", "", "notifyAddressService", "Laisexpert/backend/ais/AisNotifyAddressService;", "notifyTriggerService", "Laisexpert/backend/ais/AisNotifyTriggerService;", "batchUpdateService", "Laisexpert/backend/web/BatchUpdateService;", "(Laisexpert/backend/ais/AisNotifyAddressService;Laisexpert/backend/ais/AisNotifyTriggerService;Laisexpert/backend/web/BatchUpdateService;)V", "createAddress", "Laisexpert/backend/ais/NotifyAddressDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "data", "Laisexpert/backend/web/NotifyAddressCreateDto;", "createTrigger", "Laisexpert/backend/ais/NotifyTriggerDto;", "Laisexpert/backend/web/NotifyTriggerCreateDto;", "getAddress", "id", "", "getTrigger", "listAddresses", "", "listTriggers", "updateAddresses", "Laisexpert/backend/web/BatchResult;", "Laisexpert/backend/web/BatchUpdate;", "Laisexpert/backend/web/NotifyAddressUpdateDto;", "updateTriggers", "Laisexpert/backend/web/NotifyTriggerUpdateDto;", "aisexpert-backend"})
public class NotifyController {
    private final AisNotifyAddressService notifyAddressService;
    private final AisNotifyTriggerService notifyTriggerService;
    private final BatchUpdateService batchUpdateService;

    @GetMapping(value={"/addresses"})
    @NotNull
    public List<NotifyAddressDto> listAddresses(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.notifyAddressService.list(authToken.getHashId(), new NotifyAddressListCommand(null, 1, null)).getItems();
    }

    @PostMapping(value={"/addresses"})
    @NotNull
    public NotifyAddressDto createAddress(@NotNull AuthToken authToken, @RequestBody @NotNull NotifyAddressCreateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return this.notifyAddressService.create(authToken.getHashId(), new NotifyAddressCreateCommand(data.getName(), data.getEmail(), data.getTriggers(), null, 8, null));
    }

    @GetMapping(value={"/addresses/{id}"})
    @NotNull
    public NotifyAddressDto getAddress(@NotNull AuthToken authToken, @PathVariable @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.notifyAddressService.info(authToken.getHashId(), new NotifyAddressInfoCommand(id));
    }

    @PatchMapping(value={"/addresses/update-multiple"})
    @NotNull
    public BatchResult<NotifyAddressDto> updateAddresses(@NotNull AuthToken authToken, @RequestBody @NotNull BatchUpdate<NotifyAddressUpdateDto> data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        return this.batchUpdateService.invoke(data, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GetMapping(value={"/triggers"})
    @NotNull
    public List<NotifyTriggerDto> listTriggers(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.notifyTriggerService.list(authToken.getHashId(), new NotifyTriggerListCommand(null, 1, null)).getItems();
    }

    @PostMapping(value={"/triggers"})
    @NotNull
    public NotifyTriggerDto createTrigger(@NotNull AuthToken authToken, @RequestBody @NotNull NotifyTriggerCreateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = null;
        int n = data.getThreshold();
        String string2 = data.getSubject();
        String string3 = data.getMessageTemplate();
        int n2 = data.getEmissionInterval();
        return this.notifyTriggerService.create(authToken.getHashId(), new NotifyTriggerCreateCommand(data.getName(), data.getType(), n, n2, string2, string3, string, 64, null));
    }

    @GetMapping(value={"/triggers/{id}"})
    @NotNull
    public NotifyTriggerDto getTrigger(@NotNull AuthToken authToken, @PathVariable @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.notifyTriggerService.info(authToken.getHashId(), new NotifyTriggerInfoCommand(id));
    }

    @PatchMapping(value={"/triggers/update-multiple"})
    @NotNull
    public BatchResult<NotifyTriggerDto> updateTriggers(@NotNull AuthToken authToken, @RequestBody @NotNull BatchUpdate<NotifyTriggerUpdateDto> data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        return this.batchUpdateService.invoke(data, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public NotifyController(@NotNull AisNotifyAddressService notifyAddressService, @NotNull AisNotifyTriggerService notifyTriggerService, @NotNull BatchUpdateService batchUpdateService) {
        Intrinsics.checkParameterIsNotNull((Object)notifyAddressService, (String)"notifyAddressService");
        Intrinsics.checkParameterIsNotNull((Object)notifyTriggerService, (String)"notifyTriggerService");
        Intrinsics.checkParameterIsNotNull((Object)batchUpdateService, (String)"batchUpdateService");
        this.notifyAddressService = notifyAddressService;
        this.notifyTriggerService = notifyTriggerService;
        this.batchUpdateService = batchUpdateService;
    }

    public static final /* synthetic */ AisNotifyAddressService access$getNotifyAddressService$p(NotifyController $this) {
        return $this.notifyAddressService;
    }

    public static final /* synthetic */ AisNotifyTriggerService access$getNotifyTriggerService$p(NotifyController $this) {
        return $this.notifyTriggerService;
    }
}

