/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisNsiService;
import aisexpert.backend.ais.NsiLpu;
import aisexpert.backend.ais.NsiLpuAnswer;
import aisexpert.backend.ais.NsiLpuCommand;
import aisexpert.backend.ais.NsiLpuFilter;
import aisexpert.backend.ais.NsiMkb;
import aisexpert.backend.ais.NsiMkbCommand;
import aisexpert.backend.ais.NsiMkbFilter;
import aisexpert.backend.ais.NsiProfile;
import aisexpert.backend.ais.NsiProfileCommand;
import aisexpert.backend.ais.NsiSyncDto;
import aisexpert.backend.ais.NsiVidmp;
import aisexpert.backend.ais.NsiVidmpCommand;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.NsiSyncUpdateDto;
import java.time.OffsetDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/nsi"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JI\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0003\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u000f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000f\u001a\u00020\u000bH\u0017JG\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0003\u0010\u0015\u001a\u0004\u0018\u00010\r2\n\b\u0003\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\b\b\u0003\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u000f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0017J\u001a\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017J \u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000f\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Laisexpert/backend/web/NsiController;", "", "aisNsiService", "Laisexpert/backend/ais/AisNsiService;", "(Laisexpert/backend/ais/AisNsiService;)V", "lpu", "", "Laisexpert/backend/ais/NsiLpu;", "authToken", "Laisexpert/backend/entity/AuthToken;", "lpuSearch", "", "offset", "", "limit", "scoreId", "(Laisexpert/backend/entity/AuthToken;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Ljava/util/List;", "medProfile", "Laisexpert/backend/ais/NsiProfile;", "mkb", "Laisexpert/backend/ais/NsiMkb;", "parentId", "mkbSearch", "onlyMkbCode", "", "(Laisexpert/backend/entity/AuthToken;Ljava/lang/Integer;Ljava/lang/String;ZLjava/lang/String;)Ljava/util/List;", "syncInfo", "Laisexpert/backend/ais/NsiSyncDto;", "syncNow", "", "syncUpdate", "data", "Laisexpert/backend/web/NsiSyncUpdateDto;", "vidmp", "Laisexpert/backend/ais/NsiVidmp;", "aisexpert-backend"})
public class NsiController {
    private final AisNsiService aisNsiService;

    @GetMapping(value={"/vidmp"})
    @NotNull
    public List<NsiVidmp> vidmp(@NotNull AuthToken authToken, @RequestParam @NotNull String scoreId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)scoreId, (String)"scoreId");
        return this.aisNsiService.vidmp(authToken.getHashId(), new NsiVidmpCommand(scoreId, null, 2, null)).getItems();
    }

    @GetMapping(value={"/med-profile"})
    @NotNull
    public List<NsiProfile> medProfile(@NotNull AuthToken authToken, @RequestParam @NotNull String scoreId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)scoreId, (String)"scoreId");
        return this.aisNsiService.profile(authToken.getHashId(), new NsiProfileCommand(scoreId, null, 2, null)).getItems();
    }

    @GetMapping(value={"/lpu"})
    @NotNull
    public List<NsiLpu> lpu(@NotNull AuthToken authToken, @RequestParam(required=false) @Nullable String lpuSearch, @RequestParam(required=false) @Nullable Integer offset, @RequestParam(required=false) @Nullable Integer limit, @RequestParam @NotNull String scoreId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)scoreId, (String)"scoreId");
        long l = authToken.getHashId();
        String string = lpuSearch;
        if (string == null) {
            string = "";
        }
        NsiLpuAnswer result = this.aisNsiService.lpu(l, new NsiLpuCommand(new NsiLpuFilter(scoreId, string), null, 2, null));
        return result.getItems();
    }

    @GetMapping(value={"/lpu"})
    @NotNull
    public static /* synthetic */ List lpu$default(NsiController nsiController, AuthToken authToken, String string, Integer n, Integer n2, String string2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lpu");
        }
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return nsiController.lpu(authToken, string, n, n2, string2);
    }

    @GetMapping(value={"/mkb"})
    @NotNull
    public List<NsiMkb> mkb(@NotNull AuthToken authToken, @RequestParam(required=false) @Nullable Integer parentId, @RequestParam(required=false) @Nullable String mkbSearch, @RequestParam(required=false) boolean onlyMkbCode, @RequestParam @NotNull String scoreId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)scoreId, (String)"scoreId");
        long l = authToken.getHashId();
        Integer n = parentId;
        int n2 = n != null ? n : -1;
        String string = mkbSearch;
        if (string == null) {
            string = "";
        }
        return this.aisNsiService.mkb(l, new NsiMkbCommand(new NsiMkbFilter(scoreId, n2, string, onlyMkbCode), null, 2, null)).getItems();
    }

    @GetMapping(value={"/mkb"})
    @NotNull
    public static /* synthetic */ List mkb$default(NsiController nsiController, AuthToken authToken, Integer n, String string, boolean bl, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: mkb");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return nsiController.mkb(authToken, n, string, bl, string2);
    }

    @GetMapping(value={"/sync"})
    @NotNull
    public NsiSyncDto syncInfo(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.aisNsiService.syncInfo(authToken.getHashId());
    }

    @PatchMapping(value={"/sync"})
    @NotNull
    public NsiSyncDto syncUpdate(@NotNull AuthToken authToken, @RequestBody @NotNull NsiSyncUpdateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        NsiSyncDto sync = this.aisNsiService.syncInfo(authToken.getHashId());
        Boolean bl = data.isEnabled();
        boolean bl2 = bl != null ? bl.booleanValue() : sync.isEnabled();
        OffsetDateTime offsetDateTime = data.getNextDateTime();
        if (offsetDateTime == null) {
            offsetDateTime = sync.getNextDateTime();
        }
        Integer n = data.getAttemptInterval();
        Integer n2 = data.getAttemptLimit();
        int n3 = n2 != null ? n2.intValue() : sync.getAttemptLimit();
        int n4 = n != null ? n.intValue() : sync.getAttemptInterval();
        sync = NsiSyncDto.copy$default((NsiSyncDto)sync, null, (boolean)bl2, (boolean)false, null, (OffsetDateTime)offsetDateTime, null, (int)n3, (int)n4, (int)45, null);
        this.aisNsiService.syncEdit(authToken.getHashId(), sync);
        return sync;
    }

    @PostMapping(value={"/sync/send-now"})
    public void syncNow(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        this.aisNsiService.syncNow(authToken.getHashId());
    }

    public NsiController(@NotNull AisNsiService aisNsiService) {
        Intrinsics.checkParameterIsNotNull((Object)aisNsiService, (String)"aisNsiService");
        this.aisNsiService = aisNsiService;
    }
}

