/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisReportService;
import aisexpert.backend.ais.PagingRequest;
import aisexpert.backend.ais.ReportDataCommand;
import aisexpert.backend.ais.ReportDataItem;
import aisexpert.backend.ais.ReportDto;
import aisexpert.backend.ais.ReportFilter;
import aisexpert.backend.ais.ReportInfoCommand;
import aisexpert.backend.ais.ReportListAnswer;
import aisexpert.backend.ais.ReportListCommand;
import aisexpert.backend.ais.ReportType;
import aisexpert.backend.ais.SortOrder;
import aisexpert.backend.ais.TaskReportCreateCommand;
import aisexpert.backend.ais.TimeRange;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.BatchResult;
import aisexpert.backend.web.BatchUpdate;
import aisexpert.backend.web.BatchUpdateService;
import aisexpert.backend.web.ReportCreateDto;
import aisexpert.backend.web.ReportListDto;
import aisexpert.backend.web.ReportUpdateDto;
import java.time.OffsetDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reports"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0081\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\n\b\u0003\u0010\u0016\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u0010\u0017\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0003\u0010\u001a\u001a\u0004\u0018\u00010\u00192\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\u00192\n\b\u0003\u0010\u001c\u001a\u0004\u0018\u00010\u00192\n\b\u0003\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0003\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0003\u0010!\u001a\u0004\u0018\u00010 H\u0017\u00a2\u0006\u0002\u0010\"J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020&0%H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Laisexpert/backend/web/ReportController;", "", "aisReportService", "Laisexpert/backend/ais/AisReportService;", "batchUpdateService", "Laisexpert/backend/web/BatchUpdateService;", "(Laisexpert/backend/ais/AisReportService;Laisexpert/backend/web/BatchUpdateService;)V", "create", "Laisexpert/backend/ais/ReportDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "data", "Laisexpert/backend/web/ReportCreateDto;", "", "Laisexpert/backend/ais/ReportDataItem;", "reportId", "", "sort", "Laisexpert/backend/ais/SortOrder;", "info", "list", "Laisexpert/backend/web/ReportListDto;", "reportName", "scoreId", "periodDateFrom", "Ljava/time/OffsetDateTime;", "periodDateTo", "createDateFrom", "createDateTo", "type", "Laisexpert/backend/ais/ReportType;", "offset", "", "limit", "(Laisexpert/backend/entity/AuthToken;Ljava/lang/String;Ljava/lang/String;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Laisexpert/backend/ais/ReportType;Ljava/lang/Integer;Ljava/lang/Integer;)Laisexpert/backend/web/ReportListDto;", "update", "Laisexpert/backend/web/BatchResult;", "Laisexpert/backend/web/BatchUpdate;", "Laisexpert/backend/web/ReportUpdateDto;", "aisexpert-backend"})
public class ReportController {
    private final AisReportService aisReportService;
    private final BatchUpdateService batchUpdateService;

    @GetMapping
    @NotNull
    public ReportListDto list(@NotNull AuthToken authToken, @RequestParam(required=false) @Nullable String reportName, @RequestParam(required=false) @Nullable String scoreId, @RequestParam(required=false) @Nullable OffsetDateTime periodDateFrom, @RequestParam(required=false) @Nullable OffsetDateTime periodDateTo, @RequestParam(required=false) @Nullable OffsetDateTime createDateFrom, @RequestParam(required=false) @Nullable OffsetDateTime createDateTo, @RequestParam(required=false) @Nullable ReportType type, @RequestParam(required=false) @Nullable Integer offset, @RequestParam(required=false) @Nullable Integer limit) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        long l = authToken.getHashId();
        String string = authToken.getUserId();
        String string2 = reportName;
        if (string2 == null) {
            string2 = "";
        }
        TimeRange timeRange = new TimeRange(createDateFrom, createDateTo);
        TimeRange timeRange2 = new TimeRange(periodDateFrom, periodDateTo);
        ReportType reportType = type;
        if (reportType == null) {
            reportType = ReportType.UNDEFINED;
        }
        ReportType reportType2 = reportType;
        String string3 = scoreId;
        TimeRange timeRange3 = timeRange2;
        TimeRange timeRange4 = timeRange;
        Integer n = limit;
        Integer n2 = offset;
        ReportListAnswer result = this.aisReportService.list(l, new ReportListCommand(new ReportFilter(null, string, string2, reportType2, timeRange4, timeRange3, string3, 1, null), new PagingRequest(n != null ? n : 0, n2 != null ? n2 : 0, 0, 4, null), null, 4, null));
        return new ReportListDto(result.getPaging().getTotal(), result.getItems());
    }

    @GetMapping
    @NotNull
    public static /* synthetic */ ReportListDto list$default(ReportController reportController, AuthToken authToken, String string, String string2, OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2, OffsetDateTime offsetDateTime3, OffsetDateTime offsetDateTime4, ReportType reportType, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: list");
        }
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            offsetDateTime = null;
        }
        if ((n3 & 0x10) != 0) {
            offsetDateTime2 = null;
        }
        if ((n3 & 0x20) != 0) {
            offsetDateTime3 = null;
        }
        if ((n3 & 0x40) != 0) {
            offsetDateTime4 = null;
        }
        if ((n3 & 0x80) != 0) {
            reportType = null;
        }
        if ((n3 & 0x100) != 0) {
            n = null;
        }
        if ((n3 & 0x200) != 0) {
            n2 = null;
        }
        return reportController.list(authToken, string, string2, offsetDateTime, offsetDateTime2, offsetDateTime3, offsetDateTime4, reportType, n, n2);
    }

    @PostMapping
    @NotNull
    public ReportDto create(@NotNull AuthToken authToken, @RequestBody @NotNull ReportCreateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return this.aisReportService.createTask(authToken.getHashId(), new TaskReportCreateCommand(authToken.getUserId(), data.getScoreId(), data.getType(), data.getName(), data.getPeriod(), data.getLpu(), data.getMkb(), data.getVidmp(), data.getMedProfile(), data.getThreshold(), data.getRanging(), data.getPresent(), data.getSort(), data.getRecordCount(), null, null, null, null, null, null, 1032192, null));
    }

    @GetMapping(value={"/{reportId}"})
    @NotNull
    public ReportDto info(@NotNull AuthToken authToken, @PathVariable @NotNull String reportId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)reportId, (String)"reportId");
        return this.aisReportService.info(authToken.getHashId(), new ReportInfoCommand(reportId, authToken.getUserId()));
    }

    @GetMapping(value={"/{reportId}/data"})
    @NotNull
    public List<ReportDataItem> data(@NotNull AuthToken authToken, @PathVariable @NotNull String reportId, @RequestParam @NotNull SortOrder sort) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)reportId, (String)"reportId");
        Intrinsics.checkParameterIsNotNull((Object)sort, (String)"sort");
        return this.aisReportService.data(authToken.getHashId(), new ReportDataCommand(reportId, authToken.getUserId(), sort, null, 8, null)).getItems();
    }

    @PatchMapping(value={"/update-multiple"})
    @NotNull
    public BatchResult<ReportDto> update(@NotNull AuthToken authToken, @RequestBody @NotNull BatchUpdate<ReportUpdateDto> data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        return this.batchUpdateService.invoke(data, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ReportController(@NotNull AisReportService aisReportService, @NotNull BatchUpdateService batchUpdateService) {
        Intrinsics.checkParameterIsNotNull((Object)aisReportService, (String)"aisReportService");
        Intrinsics.checkParameterIsNotNull((Object)batchUpdateService, (String)"batchUpdateService");
        this.aisReportService = aisReportService;
        this.batchUpdateService = batchUpdateService;
    }

    public static final /* synthetic */ AisReportService access$getAisReportService$p(ReportController $this) {
        return $this.aisReportService;
    }
}

