/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisReportFedService;
import aisexpert.backend.ais.PagingRequest;
import aisexpert.backend.ais.ReportFedDeleteCommand;
import aisexpert.backend.ais.ReportFedDto;
import aisexpert.backend.ais.ReportFedEditCommand;
import aisexpert.backend.ais.ReportFedFilter;
import aisexpert.backend.ais.ReportFedInfoCommand;
import aisexpert.backend.ais.ReportFedListAnswer;
import aisexpert.backend.ais.ReportFedListCommand;
import aisexpert.backend.ais.ReportFedNameDto;
import aisexpert.backend.ais.TaskReportFedCreateCommand;
import aisexpert.backend.ais.TaskReportFedDto;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.PeriodicReportFedUpdateDto;
import aisexpert.backend.web.ReportFedCreateDto;
import aisexpert.backend.web.ReportFedListDto;
import aisexpert.backend.web.ReportFedUpdateDto;
import java.time.OffsetDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/report-fed"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J-\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0003\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0003\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0017\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u001cH\u0017J$\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\t\u001a\u00020\u001eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Laisexpert/backend/web/ReportFedController;", "", "aisReportFedService", "Laisexpert/backend/ais/AisReportFedService;", "(Laisexpert/backend/ais/AisReportFedService;)V", "create", "Laisexpert/backend/ais/ReportFedDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "data", "Laisexpert/backend/web/ReportFedCreateDto;", "delete", "", "reportId", "", "getName", "Laisexpert/backend/ais/ReportFedNameDto;", "info", "list", "Laisexpert/backend/web/ReportFedListDto;", "offset", "", "limit", "(Laisexpert/backend/entity/AuthToken;Ljava/lang/Integer;Ljava/lang/Integer;)Laisexpert/backend/web/ReportFedListDto;", "periodicInfo", "Laisexpert/backend/ais/TaskReportFedDto;", "periodicSend", "periodicUpdate", "Laisexpert/backend/web/PeriodicReportFedUpdateDto;", "update", "Laisexpert/backend/web/ReportFedUpdateDto;", "aisexpert-backend"})
public class ReportFedController {
    private final AisReportFedService aisReportFedService;

    @GetMapping
    @NotNull
    public ReportFedListDto list(@NotNull AuthToken authToken, @RequestParam(required=false) @Nullable Integer offset, @RequestParam(required=false) @Nullable Integer limit) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Integer n = limit;
        Integer n2 = offset;
        ReportFedListAnswer result = this.aisReportFedService.list(authToken.getHashId(), new ReportFedListCommand(new ReportFedFilter(null, null, null, null, null, null, 63, null), new PagingRequest(n != null ? n : 0, n2 != null ? n2 : 0, 0, 4, null), null, 4, null));
        List list = result.getItems();
        int n3 = result.getPaging().getTotal();
        return new ReportFedListDto(list, n3);
    }

    @GetMapping
    @NotNull
    public static /* synthetic */ ReportFedListDto list$default(ReportFedController reportFedController, AuthToken authToken, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: list");
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return reportFedController.list(authToken, n, n2);
    }

    @PostMapping
    @NotNull
    public ReportFedDto create(@NotNull AuthToken authToken, @RequestBody @NotNull ReportFedCreateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return this.aisReportFedService.create(authToken.getHashId(), new TaskReportFedCreateCommand(authToken.getUserId(), data.getScoreId(), data.isCorrection(), data.getPeriod(), data.getOrderNum(), null, 32, null));
    }

    @GetMapping(value={"/{reportId}"})
    @NotNull
    public ReportFedDto info(@NotNull AuthToken authToken, @PathVariable @NotNull String reportId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)reportId, (String)"reportId");
        return this.aisReportFedService.info(authToken.getHashId(), new ReportFedInfoCommand(reportId, authToken.getUserId()));
    }

    @PatchMapping(value={"/{reportId}"})
    @NotNull
    public ReportFedDto update(@NotNull AuthToken authToken, @PathVariable @NotNull String reportId, @RequestBody @NotNull ReportFedUpdateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)reportId, (String)"reportId");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        ReportFedDto report = this.aisReportFedService.info(authToken.getHashId(), new ReportFedInfoCommand(reportId, authToken.getUserId()));
        String string = data.getName();
        if (string == null) {
            string = report.getName();
        }
        report = ReportFedDto.copy$default((ReportFedDto)report, null, null, null, null, (String)string, null, null, null, (boolean)false, (boolean)false, null, null, (int)0, (int)0, (int)0, (int)32751, null);
        this.aisReportFedService.edit(authToken.getHashId(), new ReportFedEditCommand(reportId, authToken.getUserId(), report.getName()));
        return report;
    }

    @DeleteMapping(value={"/{reportId}"})
    public void delete(@NotNull AuthToken authToken, @PathVariable @NotNull String reportId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)reportId, (String)"reportId");
        this.aisReportFedService.delete(authToken.getHashId(), new ReportFedDeleteCommand(reportId, authToken.getUserId()));
    }

    @PostMapping(value={"/periodic/send-now"})
    public void periodicSend(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        this.aisReportFedService.periodicSend(authToken.getHashId());
    }

    @GetMapping(value={"/periodic"})
    @NotNull
    public TaskReportFedDto periodicInfo(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.aisReportFedService.periodicInfo(authToken.getHashId());
    }

    @PatchMapping(value={"/periodic"})
    @NotNull
    public TaskReportFedDto periodicUpdate(@NotNull AuthToken authToken, @RequestBody @NotNull PeriodicReportFedUpdateDto data) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        TaskReportFedDto report = this.aisReportFedService.periodicInfo(authToken.getHashId());
        Boolean bl = data.isEnabled();
        boolean bl2 = bl != null ? bl.booleanValue() : report.isEnabled();
        OffsetDateTime offsetDateTime = data.getNextDateTime();
        if (offsetDateTime == null) {
            offsetDateTime = report.getNextDateTime();
        }
        if ((string2 = data.getFomsCode()) == null) {
            string2 = report.getFomsCode();
        }
        if ((string = data.getStoreDir()) == null) {
            string = report.getStoreDir();
        }
        report = TaskReportFedDto.copy$default((TaskReportFedDto)report, (boolean)bl2, null, (OffsetDateTime)offsetDateTime, (String)string2, (String)string, null, null, (int)98, null);
        this.aisReportFedService.periodicEdit(authToken.getHashId(), report);
        return report;
    }

    @GetMapping(value={"/name"})
    @NotNull
    public ReportFedNameDto getName(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.aisReportFedService.name(authToken.getHashId());
    }

    public ReportFedController(@NotNull AisReportFedService aisReportFedService) {
        Intrinsics.checkParameterIsNotNull((Object)aisReportFedService, (String)"aisReportFedService");
        this.aisReportFedService = aisReportFedService;
    }
}

