/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisScoreService;
import aisexpert.backend.ais.ArchiveFilter;
import aisexpert.backend.ais.NeedSendScoreCommand;
import aisexpert.backend.ais.ScoreDto;
import aisexpert.backend.ais.ScoreFilter;
import aisexpert.backend.ais.ScoreInfoCommand;
import aisexpert.backend.ais.ScoreListCommand;
import aisexpert.backend.ais.ShowFilter;
import aisexpert.backend.ais.TimeRange;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.BatchResult;
import aisexpert.backend.web.BatchUpdate;
import aisexpert.backend.web.BatchUpdateService;
import aisexpert.backend.web.ScoreListDto;
import aisexpert.backend.web.ScoreUpdateDto;
import java.time.OffsetDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scores"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u00b7\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\n\b\u0003\u0010\u000f\u001a\u0004\u0018\u00010\f2\n\b\u0003\u0010\u0010\u001a\u0004\u0018\u00010\f2\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\b\u0003\u0010\u0014\u001a\u0004\u0018\u00010\u00122\n\b\u0003\u0010\u0015\u001a\u0004\u0018\u00010\u00122\n\b\u0003\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0010\b\u0003\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00192\n\b\u0003\u0010\u001a\u001a\u0004\u0018\u00010\f2\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\f2\n\b\u0003\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0003\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0003\u0010 \u001a\u0004\u0018\u00010\u001fH\u0017\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0001\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Laisexpert/backend/web/ScoreController;", "", "aisScoreService", "Laisexpert/backend/ais/AisScoreService;", "batchUpdateService", "Laisexpert/backend/web/BatchUpdateService;", "(Laisexpert/backend/ais/AisScoreService;Laisexpert/backend/web/BatchUpdateService;)V", "info", "Laisexpert/backend/ais/ScoreDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "scoreId", "", "list", "Laisexpert/backend/web/ScoreListDto;", "scoreName", "userId", "applyDateFrom", "Ljava/time/OffsetDateTime;", "applyDateTo", "createDateFrom", "createDateTo", "show", "Laisexpert/backend/ais/ShowFilter;", "otherUsers", "", "taskScoreId", "modelId", "archive", "Laisexpert/backend/ais/ArchiveFilter;", "offset", "", "limit", "(Laisexpert/backend/entity/AuthToken;Ljava/lang/String;Ljava/lang/String;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Laisexpert/backend/ais/ShowFilter;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Laisexpert/backend/ais/ArchiveFilter;Ljava/lang/Integer;Ljava/lang/Integer;)Laisexpert/backend/web/ScoreListDto;", "send", "update", "Laisexpert/backend/web/BatchResult;", "data", "Laisexpert/backend/web/BatchUpdate;", "Laisexpert/backend/web/ScoreUpdateDto;", "aisexpert-backend"})
public class ScoreController {
    private final AisScoreService aisScoreService;
    private final BatchUpdateService batchUpdateService;

    @GetMapping
    @NotNull
    public ScoreListDto list(@NotNull AuthToken authToken, @RequestParam(required=false) @Nullable String scoreName, @RequestParam(required=false) @Nullable String userId, @RequestParam(required=false) @Nullable OffsetDateTime applyDateFrom, @RequestParam(required=false) @Nullable OffsetDateTime applyDateTo, @RequestParam(required=false) @Nullable OffsetDateTime createDateFrom, @RequestParam(required=false) @Nullable OffsetDateTime createDateTo, @RequestParam(required=false) @Nullable ShowFilter show, @RequestParam(required=false) @Nullable List<String> otherUsers, @RequestParam(required=false) @Nullable String taskScoreId, @RequestParam(required=false) @Nullable String modelId, @RequestParam(required=false) @Nullable ArchiveFilter archive, @RequestParam(required=false) @Nullable Integer offset, @RequestParam(required=false) @Nullable Integer limit) {
        ArchiveFilter archiveFilter;
        List list;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        long l = authToken.getHashId();
        String string2 = userId;
        if (string2 == null) {
            string2 = authToken.getUserId();
        }
        if ((string = scoreName) == null) {
            string = "";
        }
        TimeRange timeRange = new TimeRange(createDateFrom, createDateTo);
        TimeRange timeRange2 = new TimeRange(applyDateFrom, applyDateTo);
        ShowFilter showFilter = show;
        if (showFilter == null) {
            showFilter = ShowFilter.SELF;
        }
        if ((list = otherUsers) == null) {
            list = CollectionsKt.emptyList();
        }
        if ((archiveFilter = archive) == null) {
            archiveFilter = ArchiveFilter.NO;
        }
        ArchiveFilter archiveFilter2 = archiveFilter;
        String string3 = modelId;
        String string4 = taskScoreId;
        List list2 = list;
        ShowFilter showFilter2 = showFilter;
        TimeRange timeRange3 = timeRange2;
        TimeRange timeRange4 = timeRange;
        String string5 = string;
        String string6 = string2;
        List scores = this.aisScoreService.list(l, new ScoreListCommand(new ScoreFilter(null, string4, string6, string5, timeRange4, timeRange3, string3, showFilter2, list2, archiveFilter2, 1, null), null, null, 6, null)).getItems();
        return new ScoreListDto(100, scores);
    }

    @GetMapping
    @NotNull
    public static /* synthetic */ ScoreListDto list$default(ScoreController scoreController, AuthToken authToken, String string, String string2, OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2, OffsetDateTime offsetDateTime3, OffsetDateTime offsetDateTime4, ShowFilter showFilter, List list, String string3, String string4, ArchiveFilter archiveFilter, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: list");
        }
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            offsetDateTime = null;
        }
        if ((n3 & 0x10) != 0) {
            offsetDateTime2 = null;
        }
        if ((n3 & 0x20) != 0) {
            offsetDateTime3 = null;
        }
        if ((n3 & 0x40) != 0) {
            offsetDateTime4 = null;
        }
        if ((n3 & 0x80) != 0) {
            showFilter = null;
        }
        if ((n3 & 0x100) != 0) {
            list = null;
        }
        if ((n3 & 0x200) != 0) {
            string3 = null;
        }
        if ((n3 & 0x400) != 0) {
            string4 = null;
        }
        if ((n3 & 0x800) != 0) {
            archiveFilter = null;
        }
        if ((n3 & 0x1000) != 0) {
            n = null;
        }
        if ((n3 & 0x2000) != 0) {
            n2 = null;
        }
        return scoreController.list(authToken, string, string2, offsetDateTime, offsetDateTime2, offsetDateTime3, offsetDateTime4, showFilter, list, string3, string4, archiveFilter, n, n2);
    }

    @GetMapping(value={"/{scoreId}"})
    @NotNull
    public ScoreDto info(@NotNull AuthToken authToken, @PathVariable @NotNull String scoreId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)scoreId, (String)"scoreId");
        return this.aisScoreService.info(authToken.getHashId(), new ScoreInfoCommand(scoreId, authToken.getUserId()));
    }

    @PostMapping(value={"/{scoreId}/send"})
    @NotNull
    public ScoreDto send(@NotNull AuthToken authToken, @PathVariable @NotNull String scoreId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)scoreId, (String)"scoreId");
        ScoreDto score = this.aisScoreService.info(authToken.getHashId(), new ScoreInfoCommand(scoreId, authToken.getUserId()));
        this.aisScoreService.send(authToken.getHashId(), new NeedSendScoreCommand(scoreId, score.getUserId()));
        return this.aisScoreService.info(authToken.getHashId(), new ScoreInfoCommand(scoreId, authToken.getUserId()));
    }

    @PatchMapping(value={"/update-multiple"})
    @NotNull
    public BatchResult<ScoreDto> update(@NotNull AuthToken authToken, @RequestBody @NotNull BatchUpdate<ScoreUpdateDto> data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        return this.batchUpdateService.invoke(data, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ScoreController(@NotNull AisScoreService aisScoreService, @NotNull BatchUpdateService batchUpdateService) {
        Intrinsics.checkParameterIsNotNull((Object)aisScoreService, (String)"aisScoreService");
        Intrinsics.checkParameterIsNotNull((Object)batchUpdateService, (String)"batchUpdateService");
        this.aisScoreService = aisScoreService;
        this.batchUpdateService = batchUpdateService;
    }

    public static final /* synthetic */ AisScoreService access$getAisScoreService$p(ScoreController $this) {
        return $this.aisScoreService;
    }
}

