/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisServiceAuthHolder;
import aisexpert.backend.ais.AisSupervisingService;
import aisexpert.backend.ais.SupervisingHardwareDto;
import aisexpert.backend.ais.SupervisingSoftwareDto;
import aisexpert.backend.ais.SupervisingThresholdDto;
import aisexpert.backend.ais.SupervisingThresholdsDto;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.spring.AisEventHandler;
import aisexpert.backend.spring.AisListener;
import aisexpert.backend.web.SimpService;
import aisexpert.backend.web.SupervisingDto;
import aisexpert.backend.web.ThresholdsUpdateDto;
import aisexpert.backend.web.UserAccessService;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.user.SimpSubscriptionMatcher;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AisListener
@RestController
@RequestMapping(value={"/api/supervising"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0012\u001a\u00020\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0011H\u0017J\u001a\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Laisexpert/backend/web/SupervisingController;", "", "simp", "Laisexpert/backend/web/SimpService;", "userRegistry", "Lorg/springframework/messaging/simp/user/SimpUserRegistry;", "userAccessService", "Laisexpert/backend/web/UserAccessService;", "aisSupervisingService", "Laisexpert/backend/ais/AisSupervisingService;", "serviceAuthHolder", "Laisexpert/backend/ais/AisServiceAuthHolder;", "(Laisexpert/backend/web/SimpService;Lorg/springframework/messaging/simp/user/SimpUserRegistry;Laisexpert/backend/web/UserAccessService;Laisexpert/backend/ais/AisSupervisingService;Laisexpert/backend/ais/AisServiceAuthHolder;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "thresholds", "Laisexpert/backend/ais/SupervisingThresholdsDto;", "fetchEntities", "", "list", "Laisexpert/backend/web/SupervisingDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "authId", "", "thresholdsUpdated", "event", "updateThresholds", "data", "Laisexpert/backend/web/ThresholdsUpdateDto;", "aisexpert-backend"})
public class SupervisingController {
    private final Logger logger;
    private SupervisingThresholdsDto thresholds;
    private final SimpService simp;
    private final SimpUserRegistry userRegistry;
    private final UserAccessService userAccessService;
    private final AisSupervisingService aisSupervisingService;
    private final AisServiceAuthHolder serviceAuthHolder;

    @GetMapping
    @NotNull
    public SupervisingDto list(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.list(authToken.getHashId());
    }

    @PatchMapping(value={"/thresholds"})
    @NotNull
    public SupervisingThresholdsDto updateThresholds(@NotNull AuthToken authToken, @RequestBody @NotNull ThresholdsUpdateDto data) {
        SupervisingThresholdDto supervisingThresholdDto;
        SupervisingThresholdDto supervisingThresholdDto2;
        SupervisingThresholdDto supervisingThresholdDto3;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        SupervisingThresholdsDto thresholds = this.aisSupervisingService.getThresholds(authToken.getHashId());
        SupervisingThresholdDto supervisingThresholdDto4 = data.getCpu();
        if (supervisingThresholdDto4 == null) {
            supervisingThresholdDto4 = thresholds.getCpu();
        }
        if ((supervisingThresholdDto3 = data.getRam()) == null) {
            supervisingThresholdDto3 = thresholds.getRam();
        }
        if ((supervisingThresholdDto2 = data.getHdd()) == null) {
            supervisingThresholdDto2 = thresholds.getHdd();
        }
        if ((supervisingThresholdDto = data.getCputmp()) == null) {
            supervisingThresholdDto = thresholds.getCputmp();
        }
        thresholds = thresholds.copy(supervisingThresholdDto4, supervisingThresholdDto3, supervisingThresholdDto2, supervisingThresholdDto);
        this.aisSupervisingService.editThresholds(authToken.getHashId(), thresholds);
        return thresholds;
    }

    @Scheduled(fixedRateString="${web.supervising-fetch-interval}")
    public void fetchEntities() {
        Set set = this.userRegistry.findSubscriptions((SimpSubscriptionMatcher)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"userRegistry.findSubscri\u2026ZoneRight.READ)\n        }");
        Set subs2 = set;
        Collection collection = subs2;
        if (!collection.isEmpty()) {
            this.logger.debug("Fetching entities...");
            SupervisingDto data = this.list(this.serviceAuthHolder.getAuth());
            this.simp.sendToSupervising(data, (Iterable)subs2);
        }
    }

    @AisEventHandler(type="c4f71462-1b05-43b4-a9b3-ccca214b460e")
    public void thresholdsUpdated(@NotNull SupervisingThresholdsDto event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.logger.info("Thresholds updated " + event);
        this.thresholds = event;
    }

    private SupervisingDto list(long authId) {
        SupervisingThresholdsDto thresholds;
        SupervisingThresholdsDto supervisingThresholdsDto = this.thresholds;
        if (supervisingThresholdsDto == null) {
            supervisingThresholdsDto = this.aisSupervisingService.getThresholds(authId);
        }
        this.thresholds = thresholds = supervisingThresholdsDto;
        aisexpert.backend.ais.SupervisingDto values = this.aisSupervisingService.get(authId);
        SupervisingThresholdsDto supervisingThresholdsDto2 = thresholds;
        SupervisingHardwareDto supervisingHardwareDto = values.getHardware();
        SupervisingSoftwareDto supervisingSoftwareDto = SupervisingSoftwareDto.copy$default((SupervisingSoftwareDto)values.getSoftware(), null, null, (int)0, (boolean)false, (int)this.userRegistry.getUserCount(), (int)15, null);
        return new SupervisingDto(supervisingHardwareDto, supervisingSoftwareDto, supervisingThresholdsDto2);
    }

    public SupervisingController(@NotNull SimpService simp, @NotNull SimpUserRegistry userRegistry, @NotNull UserAccessService userAccessService, @NotNull AisSupervisingService aisSupervisingService, @NotNull AisServiceAuthHolder serviceAuthHolder) {
        Intrinsics.checkParameterIsNotNull((Object)simp, (String)"simp");
        Intrinsics.checkParameterIsNotNull((Object)userRegistry, (String)"userRegistry");
        Intrinsics.checkParameterIsNotNull((Object)userAccessService, (String)"userAccessService");
        Intrinsics.checkParameterIsNotNull((Object)aisSupervisingService, (String)"aisSupervisingService");
        Intrinsics.checkParameterIsNotNull((Object)serviceAuthHolder, (String)"serviceAuthHolder");
        this.simp = simp;
        this.userRegistry = userRegistry;
        this.userAccessService = userAccessService;
        this.aisSupervisingService = aisSupervisingService;
        this.serviceAuthHolder = serviceAuthHolder;
        this.logger = LoggerFactory.getLogger(SupervisingController.class);
    }

    public static final /* synthetic */ UserAccessService access$getUserAccessService$p(SupervisingController $this) {
        return $this.userAccessService;
    }
}

