/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisEventLogService;
import aisexpert.backend.ais.AisVersionAnswer;
import aisexpert.backend.ais.AisVersionService;
import aisexpert.backend.ais.AisXgbService;
import aisexpert.backend.ais.EventFilter;
import aisexpert.backend.ais.EventLogListAnswer;
import aisexpert.backend.ais.EventLogListCommand;
import aisexpert.backend.ais.PagingRequest;
import aisexpert.backend.ais.XgbDto;
import aisexpert.backend.ais.XgbEditCommand;
import aisexpert.backend.ais.XgbInfoCommand;
import aisexpert.backend.ais.XgbParam;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.BackendVersionDto;
import aisexpert.backend.web.LogDto;
import com.jcabi.manifests.Manifests;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017JO\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0003\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0003\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\b\u0003\u0010\u0011\u001a\u00020\u00122\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0003\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0017\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u001a\u001a\u00020\u000fH\u0017J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Laisexpert/backend/web/SystemController;", "", "aisEventLogService", "Laisexpert/backend/ais/AisEventLogService;", "aisVersionService", "Laisexpert/backend/ais/AisVersionService;", "aisXgbService", "Laisexpert/backend/ais/AisXgbService;", "(Laisexpert/backend/ais/AisEventLogService;Laisexpert/backend/ais/AisVersionService;Laisexpert/backend/ais/AisXgbService;)V", "get", "Laisexpert/backend/web/BackendVersionDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "Laisexpert/backend/web/LogDto;", "userId", "", "taskId", "selectAll", "", "offset", "", "limit", "(Laisexpert/backend/entity/AuthToken;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Integer;Ljava/lang/Integer;)Laisexpert/backend/web/LogDto;", "info", "Laisexpert/backend/ais/XgbDto;", "modelInfo", "modelId", "update", "", "data", "", "Laisexpert/backend/ais/XgbParam;", "aisexpert-backend"})
public class SystemController {
    private final AisEventLogService aisEventLogService;
    private final AisVersionService aisVersionService;
    private final AisXgbService aisXgbService;

    @GetMapping(value={"/log"})
    @NotNull
    public LogDto get(@NotNull AuthToken authToken, @RequestParam(required=false) @Nullable String userId, @RequestParam(required=false) @Nullable String taskId, @RequestParam(required=false) boolean selectAll, @RequestParam(required=false) @Nullable Integer offset, @RequestParam(required=false) @Nullable Integer limit) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Integer n = offset;
        Integer n2 = limit;
        int n3 = 0;
        int n4 = n2 != null ? n2 : 0;
        int n5 = n != null ? n : 0;
        EventLogListAnswer result = this.aisEventLogService.list(authToken.getHashId(), new EventLogListCommand(new EventFilter(userId, taskId, selectAll, null, true, 8, null), new PagingRequest(n4, n5, n3, 4, null), null, 4, null));
        return new LogDto(result.getItems(), result.getPaging().getTotal());
    }

    @GetMapping(value={"/log"})
    @NotNull
    public static /* synthetic */ LogDto get$default(SystemController systemController, AuthToken authToken, String string, String string2, boolean bl, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        return systemController.get(authToken, string, string2, bl, n, n2);
    }

    @GetMapping(value={"/version"})
    @NotNull
    public BackendVersionDto get(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        String gitVersion = Manifests.exists((String)"Git-Version") ? Manifests.read((String)"Git-Version") : null;
        String gitRev = Manifests.exists((String)"Git-Revision") ? Manifests.read((String)"Git-Revision") : null;
        String proxyVersion = gitVersion + " (" + gitRev + ')';
        AisVersionAnswer aisVersion = this.aisVersionService.version(authToken.getHashId());
        return new BackendVersionDto(aisVersion.getStrver() + " (" + aisVersion.getGitrev() + ')', proxyVersion);
    }

    @GetMapping(value={"/xgb"})
    @NotNull
    public XgbDto info(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.aisXgbService.info(authToken.getHashId(), new XgbInfoCommand(null));
    }

    @PatchMapping(value={"/xgb"})
    public void update(@NotNull AuthToken authToken, @RequestBody @NotNull List<XgbParam> data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.aisXgbService.edit(authToken.getHashId(), new XgbEditCommand(null, data));
    }

    @GetMapping(value={"/xgb/{modelId}"})
    @NotNull
    public XgbDto modelInfo(@NotNull AuthToken authToken, @PathVariable @NotNull String modelId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)modelId, (String)"modelId");
        return this.aisXgbService.info(authToken.getHashId(), new XgbInfoCommand(modelId));
    }

    public SystemController(@NotNull AisEventLogService aisEventLogService, @NotNull AisVersionService aisVersionService, @NotNull AisXgbService aisXgbService) {
        Intrinsics.checkParameterIsNotNull((Object)aisEventLogService, (String)"aisEventLogService");
        Intrinsics.checkParameterIsNotNull((Object)aisVersionService, (String)"aisVersionService");
        Intrinsics.checkParameterIsNotNull((Object)aisXgbService, (String)"aisXgbService");
        this.aisEventLogService = aisEventLogService;
        this.aisVersionService = aisVersionService;
        this.aisXgbService = aisXgbService;
    }
}

