/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisModelService;
import aisexpert.backend.ais.AisNsiService;
import aisexpert.backend.ais.AisReportFedService;
import aisexpert.backend.ais.AisReportService;
import aisexpert.backend.ais.AisScoreService;
import aisexpert.backend.ais.AisServiceAuthHolder;
import aisexpert.backend.ais.AisTaskService;
import aisexpert.backend.ais.ModelInfoCommand;
import aisexpert.backend.ais.NsiSyncDto;
import aisexpert.backend.ais.ReportFedInfoCommand;
import aisexpert.backend.ais.ReportInfoCommand;
import aisexpert.backend.ais.ScoreInfoCommand;
import aisexpert.backend.ais.SyncInfo;
import aisexpert.backend.ais.SyncProgressCommand;
import aisexpert.backend.ais.TaskContentCreate;
import aisexpert.backend.ais.TaskProgress;
import aisexpert.backend.ais.TaskStartNowCommand;
import aisexpert.backend.ais.TaskType;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.spring.AisEventHandler;
import aisexpert.backend.spring.AisListener;
import aisexpert.backend.web.SimpService;
import aisexpert.backend.web.TaskController;
import aisexpert.backend.web.TaskController$WhenMappings;
import aisexpert.backend.web.TrulyTaskContentCreate;
import aisexpert.backend.web.TrulyTaskProgress;
import aisexpert.backend.web.UserAccessService;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.user.SimpSubscription;
import org.springframework.messaging.simp.user.SimpSubscriptionMatcher;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tasks"})
@AisListener
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0017J(\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0012J\u001a\u0010.\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010/\u001a\u00020+H\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Laisexpert/backend/web/TaskController;", "", "simpService", "Laisexpert/backend/web/SimpService;", "aisTaskService", "Laisexpert/backend/ais/AisTaskService;", "userRegistry", "Lorg/springframework/messaging/simp/user/SimpUserRegistry;", "userAccessService", "Laisexpert/backend/web/UserAccessService;", "aisModelService", "Laisexpert/backend/ais/AisModelService;", "aisScoreService", "Laisexpert/backend/ais/AisScoreService;", "aisReportService", "Laisexpert/backend/ais/AisReportService;", "aisReportFedService", "Laisexpert/backend/ais/AisReportFedService;", "aisNsiService", "Laisexpert/backend/ais/AisNsiService;", "aisServiceAuthHolder", "Laisexpert/backend/ais/AisServiceAuthHolder;", "(Laisexpert/backend/web/SimpService;Laisexpert/backend/ais/AisTaskService;Lorg/springframework/messaging/simp/user/SimpUserRegistry;Laisexpert/backend/web/UserAccessService;Laisexpert/backend/ais/AisModelService;Laisexpert/backend/ais/AisScoreService;Laisexpert/backend/ais/AisReportService;Laisexpert/backend/ais/AisReportFedService;Laisexpert/backend/ais/AisNsiService;Laisexpert/backend/ais/AisServiceAuthHolder;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getSyncQueue", "", "Laisexpert/backend/ais/SyncInfo;", "authToken", "Laisexpert/backend/entity/AuthToken;", "onContentCreate", "", "event", "Laisexpert/backend/ais/TaskContentCreate;", "onProgress", "Laisexpert/backend/ais/TaskProgress;", "selectSubsWithAccess", "", "Lorg/springframework/messaging/simp/user/SimpSubscription;", "taskType", "Laisexpert/backend/ais/TaskType;", "userId", "", "isPublic", "", "startNow", "taskId", "aisexpert-backend"})
public class TaskController {
    private final Logger logger;
    private final SimpService simpService;
    private final AisTaskService aisTaskService;
    private final SimpUserRegistry userRegistry;
    private final UserAccessService userAccessService;
    private final AisModelService aisModelService;
    private final AisScoreService aisScoreService;
    private final AisReportService aisReportService;
    private final AisReportFedService aisReportFedService;
    private final AisNsiService aisNsiService;
    private final AisServiceAuthHolder aisServiceAuthHolder;

    @PostMapping(value={"/{taskId}/start-now"})
    public void startNow(@NotNull AuthToken authToken, @PathVariable @NotNull String taskId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)taskId, (String)"taskId");
        this.aisTaskService.startNow(authToken.getHashId(), new TaskStartNowCommand(taskId, authToken.getUserId()));
    }

    @GetMapping(value={"/sync-queue"})
    @NotNull
    public List<SyncInfo> getSyncQueue(@NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        return this.aisTaskService.syncProgress(authToken.getHashId(), new SyncProgressCommand(null, 1, null)).getItems();
    }

    @AisEventHandler(type="12561ec5-e3ba-45ff-96b8-f147456afaba")
    public void onProgress(@NotNull TaskProgress event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.logger.info("TaskProgress event = " + event);
        Set subs2 = this.selectSubsWithAccess(event.getTaskType(), event.getUserId(), event.isPeriodic());
        this.simpService.sendToTaskProgress(new TrulyTaskProgress(event.getTaskType(), event.getTaskId(), event.getCurrent(), event.getTotal(), event.getTaskName(), event.getTaskDescript(), event.getTaskCreateDate(), event.getTaskExecStatus(), event.getWaitPosition()), (Iterable)subs2);
    }

    @AisEventHandler(type="2e51292d-c37a-4dcb-9035-6f78a38569e6")
    public void onContentCreate(@NotNull TaskContentCreate event) {
        NsiSyncDto content;
        NsiSyncDto nsiSyncDto;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.logger.info("TaskContentCreate event = " + event);
        Set subs2 = this.selectSubsWithAccess(event.getTaskType(), event.getUserId(), event.isPeriodic());
        switch (TaskController$WhenMappings.$EnumSwitchMapping$0[event.getTaskType().ordinal()]) {
            case 1: {
                nsiSyncDto = null;
                break;
            }
            case 2: {
                nsiSyncDto = null;
                break;
            }
            case 3: {
                nsiSyncDto = null;
                break;
            }
            case 4: {
                nsiSyncDto = null;
                break;
            }
            case 5: {
                nsiSyncDto = this.aisModelService.info(this.aisServiceAuthHolder.getAuth(), new ModelInfoCommand(event.getContentId(), event.getUserId()));
                break;
            }
            case 6: {
                nsiSyncDto = this.aisScoreService.info(this.aisServiceAuthHolder.getAuth(), new ScoreInfoCommand(event.getContentId(), event.getUserId()));
                break;
            }
            case 7: {
                nsiSyncDto = this.aisReportService.info(this.aisServiceAuthHolder.getAuth(), new ReportInfoCommand(event.getContentId(), event.getUserId()));
                break;
            }
            case 8: {
                nsiSyncDto = this.aisReportFedService.info(this.aisServiceAuthHolder.getAuth(), new ReportFedInfoCommand(event.getContentId(), event.getUserId()));
                break;
            }
            case 9: {
                nsiSyncDto = null;
                break;
            }
            case 10: {
                nsiSyncDto = this.aisNsiService.syncInfo(this.aisServiceAuthHolder.getAuth());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        NsiSyncDto nsiSyncDto2 = content = nsiSyncDto;
        String string = event.getUserId();
        this.simpService.sendToTaskCreate(new TrulyTaskContentCreate(event.getTaskType(), event.getTaskId(), (Object)nsiSyncDto2, string), (Iterable)subs2);
    }

    private Set<SimpSubscription> selectSubsWithAccess(TaskType taskType, String userId, boolean isPublic) {
        Function1 function1;
        switch (TaskController$WhenMappings.$EnumSwitchMapping$1[taskType.ordinal()]) {
            case 1: {
                function1 = (Function1)selectSubsWithAccess.roleAccess.1.INSTANCE;
                break;
            }
            case 2: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 3: {
                function1 = (Function1)selectSubsWithAccess.roleAccess.3.INSTANCE;
                break;
            }
            case 4: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 5: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 6: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 7: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 8: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 9: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 10: {
                function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Function1 roleAccess2 = function1;
        Set set = this.userRegistry.findSubscriptions((SimpSubscriptionMatcher)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"userRegistry.findSubscri\u2026ll || isPublic)\n        }");
        return set;
    }

    public TaskController(@NotNull SimpService simpService, @NotNull AisTaskService aisTaskService, @NotNull SimpUserRegistry userRegistry, @NotNull UserAccessService userAccessService, @NotNull AisModelService aisModelService, @NotNull AisScoreService aisScoreService, @NotNull AisReportService aisReportService, @NotNull AisReportFedService aisReportFedService, @NotNull AisNsiService aisNsiService, @NotNull AisServiceAuthHolder aisServiceAuthHolder) {
        Intrinsics.checkParameterIsNotNull((Object)simpService, (String)"simpService");
        Intrinsics.checkParameterIsNotNull((Object)aisTaskService, (String)"aisTaskService");
        Intrinsics.checkParameterIsNotNull((Object)userRegistry, (String)"userRegistry");
        Intrinsics.checkParameterIsNotNull((Object)userAccessService, (String)"userAccessService");
        Intrinsics.checkParameterIsNotNull((Object)aisModelService, (String)"aisModelService");
        Intrinsics.checkParameterIsNotNull((Object)aisScoreService, (String)"aisScoreService");
        Intrinsics.checkParameterIsNotNull((Object)aisReportService, (String)"aisReportService");
        Intrinsics.checkParameterIsNotNull((Object)aisReportFedService, (String)"aisReportFedService");
        Intrinsics.checkParameterIsNotNull((Object)aisNsiService, (String)"aisNsiService");
        Intrinsics.checkParameterIsNotNull((Object)aisServiceAuthHolder, (String)"aisServiceAuthHolder");
        this.simpService = simpService;
        this.aisTaskService = aisTaskService;
        this.userRegistry = userRegistry;
        this.userAccessService = userAccessService;
        this.aisModelService = aisModelService;
        this.aisScoreService = aisScoreService;
        this.aisReportService = aisReportService;
        this.aisReportFedService = aisReportFedService;
        this.aisNsiService = aisNsiService;
        this.aisServiceAuthHolder = aisServiceAuthHolder;
        this.logger = LoggerFactory.getLogger(TaskController.class);
    }

    public static final /* synthetic */ UserAccessService access$getUserAccessService$p(TaskController $this) {
        return $this.userAccessService;
    }
}

