/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisTaskScoreService;
import aisexpert.backend.ais.AisTaskService;
import aisexpert.backend.ais.TaskExecStatus;
import aisexpert.backend.ais.TaskFilter;
import aisexpert.backend.ais.TaskInterruptCommand;
import aisexpert.backend.ais.TaskScoreCreateCommand;
import aisexpert.backend.ais.TaskScoreDto;
import aisexpert.backend.ais.TaskScoreInfoCommand;
import aisexpert.backend.ais.TaskScoreListCommand;
import aisexpert.backend.ais.TaskType;
import aisexpert.backend.ais.TimeRange;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.web.BatchResult;
import aisexpert.backend.web.BatchUpdate;
import aisexpert.backend.web.BatchUpdateService;
import aisexpert.backend.web.PeriodicTaskScoreCreateDto;
import aisexpert.backend.web.PeriodicTaskScoreUpdateDto;
import aisexpert.backend.web.SimpleTaskScoreCreateDto;
import aisexpert.backend.web.SimpleTaskScoreUpdateDto;
import aisexpert.backend.web.TaskScoreCreateDto;
import aisexpert.backend.web.TaskScoreUpdateDto;
import java.time.OffsetDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tasks/scores"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u0010H\u0017J\u001a\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u0012H\u0017J\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J?\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\n\b\u0003\u0010\u001a\u001a\u0004\u0018\u00010\u00152\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\u00152\n\b\u0003\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0017J\u001a\u0010#\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020$H\u0017J\u001a\u0010%\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020&H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Laisexpert/backend/web/TaskScoreController;", "", "aisTaskScoreService", "Laisexpert/backend/ais/AisTaskScoreService;", "aisTaskService", "Laisexpert/backend/ais/AisTaskService;", "batchUpdateService", "Laisexpert/backend/web/BatchUpdateService;", "(Laisexpert/backend/ais/AisTaskScoreService;Laisexpert/backend/ais/AisTaskService;Laisexpert/backend/web/BatchUpdateService;)V", "create", "Laisexpert/backend/ais/TaskScoreDto;", "authToken", "Laisexpert/backend/entity/AuthToken;", "data", "Laisexpert/backend/web/TaskScoreCreateDto;", "createPeriodic", "Laisexpert/backend/web/PeriodicTaskScoreCreateDto;", "createSimple", "Laisexpert/backend/web/SimpleTaskScoreCreateDto;", "get", "taskId", "", "interrupt", "", "list", "", "taskModelId", "modelId", "showOtherUsers", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Laisexpert/backend/entity/AuthToken;)Ljava/util/List;", "update", "Laisexpert/backend/web/BatchResult;", "Laisexpert/backend/web/BatchUpdate;", "Laisexpert/backend/web/TaskScoreUpdateDto;", "updatePeriodic", "Laisexpert/backend/web/PeriodicTaskScoreUpdateDto;", "updateSimple", "Laisexpert/backend/web/SimpleTaskScoreUpdateDto;", "aisexpert-backend"})
public class TaskScoreController {
    private final AisTaskScoreService aisTaskScoreService;
    private final AisTaskService aisTaskService;
    private final BatchUpdateService batchUpdateService;

    @GetMapping
    @NotNull
    public List<TaskScoreDto> list(@RequestParam(required=false) @Nullable String taskModelId, @RequestParam(required=false) @Nullable String modelId, @RequestParam(required=false) @Nullable Boolean showOtherUsers, @NotNull AuthToken authToken) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Boolean bl = showOtherUsers;
        boolean bl2 = bl != null ? bl : false;
        String string = modelId;
        String string2 = taskModelId;
        return this.aisTaskScoreService.list(authToken.getHashId(), new TaskScoreListCommand(new TaskFilter(null, authToken.getUserId(), null, string, string2, bl2, 5, null), null, 2, null)).getItems();
    }

    @GetMapping
    @NotNull
    public static /* synthetic */ List list$default(TaskScoreController taskScoreController, String string, String string2, Boolean bl, AuthToken authToken, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: list");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return taskScoreController.list(string, string2, bl, authToken);
    }

    @GetMapping(value={"/{taskId}"})
    @NotNull
    public TaskScoreDto get(@NotNull AuthToken authToken, @PathVariable @NotNull String taskId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)taskId, (String)"taskId");
        return this.aisTaskScoreService.info(authToken.getHashId(), new TaskScoreInfoCommand(taskId, authToken.getUserId()));
    }

    @PostMapping(value={"/{taskId}/interrupt"})
    public void interrupt(@NotNull AuthToken authToken, @PathVariable @NotNull String taskId) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)taskId, (String)"taskId");
        this.aisTaskService.interrupt(authToken.getHashId(), new TaskInterruptCommand(taskId, TaskType.SCORE_CALC, authToken.getUserId()));
    }

    @PatchMapping(value={"/update-multiple"})
    @NotNull
    public BatchResult<TaskScoreDto> update(@NotNull AuthToken authToken, @RequestBody @NotNull BatchUpdate<TaskScoreUpdateDto> data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        return this.batchUpdateService.invoke(data, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @PostMapping
    @NotNull
    public TaskScoreDto create(@NotNull AuthToken authToken, @RequestBody @NotNull TaskScoreCreateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        OffsetDateTime offsetDateTime = null;
        OffsetDateTime offsetDateTime2 = null;
        String string3 = null;
        boolean bl = data.getSkipSync();
        boolean bl2 = false;
        OffsetDateTime offsetDateTime3 = data.getRunDateTime();
        TaskExecStatus taskExecStatus = TaskExecStatus.NOT_RUN;
        boolean bl3 = data.isPublic();
        short s = data.getRelPeriodDuration();
        short s2 = data.getRelPeriodBegin();
        TimeRange timeRange = data.getPeriod();
        boolean bl4 = data.isEnabled();
        int n4 = data.getAttemptInterval();
        int n5 = data.getAttemptLimit();
        int n6 = data.getRegularityHour();
        int n7 = data.getRegularityDay();
        int n8 = data.getRegularityMonth();
        String string4 = data.getDescription();
        String string5 = data.getName();
        String string6 = data.getModelId();
        TaskScoreDto result = this.aisTaskScoreService.create(authToken.getHashId(), new TaskScoreCreateCommand(authToken.getUserId(), null, string5, string4, n8, n7, n6, n5, n4, bl4, taskExecStatus, offsetDateTime3, bl2, bl, string6, timeRange, s2, s, bl3, string3, offsetDateTime2, offsetDateTime, n3, n2, n, string2, string, 133693440, null));
        return this.aisTaskScoreService.info(authToken.getHashId(), new TaskScoreInfoCommand(result.getId(), authToken.getUserId()));
    }

    @PostMapping(value={"/simple"})
    @NotNull
    public TaskScoreDto createSimple(@NotNull AuthToken authToken, @RequestBody @NotNull SimpleTaskScoreCreateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        long l = authToken.getHashId();
        String string = authToken.getUserId();
        String string2 = data.getName();
        String string3 = data.getDescription();
        TimeRange timeRange = data.getPeriod();
        boolean bl = data.isPublic();
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"OffsetDateTime.now()");
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        OffsetDateTime offsetDateTime2 = null;
        OffsetDateTime offsetDateTime3 = null;
        String string6 = null;
        boolean bl2 = data.getSkipSync();
        boolean bl3 = false;
        String string7 = data.getModelId();
        OffsetDateTime offsetDateTime4 = offsetDateTime;
        TaskExecStatus taskExecStatus = TaskExecStatus.NOT_RUN;
        boolean bl4 = bl;
        short s = 0;
        short s2 = 0;
        TimeRange timeRange2 = timeRange;
        TaskScoreDto result = this.aisTaskScoreService.create(l, new TaskScoreCreateCommand(string, null, string2, string3, 0, 0, 0, 5, 15, true, taskExecStatus, offsetDateTime4, bl3, bl2, string7, timeRange2, s2, s, bl4, string6, offsetDateTime3, offsetDateTime2, n3, n2, n, string5, string4, 133693440, null));
        return this.aisTaskScoreService.info(authToken.getHashId(), new TaskScoreInfoCommand(result.getId(), authToken.getUserId()));
    }

    @PatchMapping(value={"/simple"})
    @NotNull
    public TaskScoreDto updateSimple(@NotNull AuthToken authToken, @RequestBody @NotNull SimpleTaskScoreUpdateDto data) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        TaskScoreDto task = this.aisTaskScoreService.info(authToken.getHashId(), new TaskScoreInfoCommand(data.getId(), authToken.getUserId()));
        String string2 = data.getName();
        if (string2 == null) {
            string2 = task.getName();
        }
        if ((string = data.getDescription()) == null) {
            string = task.getDescription();
        }
        TimeRange timeRange = task.getPeriod().update(data.getPeriod());
        Boolean bl = data.isPublic();
        boolean bl2 = bl != null ? bl.booleanValue() : task.isPublic();
        String string3 = data.getModelId();
        if (string3 == null) {
            string3 = task.getModelId();
        }
        Boolean bl3 = data.getSkipSync();
        OffsetDateTime offsetDateTime = null;
        boolean bl4 = bl3 != null ? bl3.booleanValue() : task.getSkipSync();
        String string4 = string3;
        boolean bl5 = bl2;
        short s = 0;
        String string5 = null;
        short s2 = 0;
        TimeRange timeRange2 = timeRange;
        task = TaskScoreDto.copy$default((TaskScoreDto)task, null, null, null, null, (String)string2, (String)string, null, null, (int)0, (int)0, (int)0, null, (int)0, (int)0, (int)0, (boolean)false, null, (int)0, (int)0, (int)0, (boolean)false, (boolean)bl4, (String)string4, string5, (TimeRange)timeRange2, (short)s2, (short)s, (boolean)bl5, offsetDateTime, (int)278919375, null);
        this.aisTaskScoreService.edit(authToken.getHashId(), task);
        return task;
    }

    @PostMapping(value={"/periodic"})
    @NotNull
    public TaskScoreDto createPeriodic(@NotNull AuthToken authToken, @RequestBody @NotNull PeriodicTaskScoreCreateDto data) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        OffsetDateTime offsetDateTime = null;
        OffsetDateTime offsetDateTime2 = null;
        String string3 = null;
        boolean bl = data.getSkipSync();
        boolean bl2 = data.getRunChildTask();
        String string4 = null;
        OffsetDateTime offsetDateTime3 = data.getRunDateTime();
        TaskExecStatus taskExecStatus = TaskExecStatus.NOT_RUN;
        boolean bl3 = data.isPublic();
        short s = data.getPeriodDuration();
        short s2 = 0;
        TimeRange timeRange = new TimeRange(null, null);
        TaskScoreDto result = this.aisTaskScoreService.create(authToken.getHashId(), new TaskScoreCreateCommand(authToken.getUserId(), data.getTaskModelId(), data.getName(), data.getDescription(), 1, 0, 0, 5, 15, data.isEnabled(), taskExecStatus, offsetDateTime3, bl2, bl, string4, timeRange, s2, s, bl3, string3, offsetDateTime2, offsetDateTime, n3, n2, n, string2, string, 133693440, null));
        return this.aisTaskScoreService.info(authToken.getHashId(), new TaskScoreInfoCommand(result.getId(), authToken.getUserId()));
    }

    @PatchMapping(value={"/periodic"})
    @NotNull
    public TaskScoreDto updatePeriodic(@NotNull AuthToken authToken, @RequestBody @NotNull PeriodicTaskScoreUpdateDto data) {
        String string;
        OffsetDateTime offsetDateTime;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        TaskScoreDto task = this.aisTaskScoreService.info(authToken.getHashId(), new TaskScoreInfoCommand(data.getId(), authToken.getUserId()));
        String string3 = data.getName();
        if (string3 == null) {
            string3 = task.getName();
        }
        if ((string2 = data.getDescription()) == null) {
            string2 = task.getDescription();
        }
        Boolean bl = data.isEnabled();
        boolean bl2 = bl != null ? bl.booleanValue() : task.isEnabled();
        Short s = data.getPeriodDuration();
        short s2 = s != null ? s.shortValue() : task.getRelPeriodDuration();
        Boolean bl3 = data.isPublic();
        boolean bl4 = bl3 != null ? bl3.booleanValue() : task.isPublic();
        OffsetDateTime offsetDateTime2 = data.getRunDateTime();
        if (offsetDateTime2 == null) {
            offsetDateTime2 = task.getRunDateTime();
        }
        if ((offsetDateTime = data.getNextDateTime()) == null) {
            offsetDateTime = task.getNextDateTime();
        }
        if ((string = data.getTaskModelId()) == null) {
            string = task.getParentId();
        }
        Boolean bl5 = data.getRunChildTask();
        Boolean bl6 = data.getSkipSync();
        OffsetDateTime offsetDateTime3 = null;
        boolean bl7 = bl6 != null ? bl6.booleanValue() : task.getSkipSync();
        boolean bl8 = bl5 != null ? bl5.booleanValue() : task.getRunChildTask();
        String string4 = string;
        TimeRange timeRange = null;
        String string5 = null;
        String string6 = null;
        OffsetDateTime offsetDateTime4 = offsetDateTime;
        OffsetDateTime offsetDateTime5 = offsetDateTime2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TaskExecStatus taskExecStatus = null;
        boolean bl9 = bl4;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        short s3 = s2;
        short s4 = 0;
        boolean bl10 = bl2;
        int n7 = 0;
        int n8 = 0;
        OffsetDateTime offsetDateTime6 = null;
        int n9 = 1;
        String string7 = string2;
        String string8 = null;
        String string9 = string3;
        task = TaskScoreDto.copy$default((TaskScoreDto)task, null, null, (String)string4, string8, (String)string9, (String)string7, offsetDateTime6, (OffsetDateTime)offsetDateTime5, (int)n9, (int)n8, (int)n7, (OffsetDateTime)offsetDateTime4, (int)n6, (int)n5, (int)n4, (boolean)bl10, taskExecStatus, (int)n3, (int)n2, (int)n, (boolean)bl8, (boolean)bl7, string6, string5, timeRange, (short)s4, (short)s3, (boolean)bl9, offsetDateTime3, (int)298807371, null);
        this.aisTaskScoreService.edit(authToken.getHashId(), task);
        return task;
    }

    public TaskScoreController(@NotNull AisTaskScoreService aisTaskScoreService, @NotNull AisTaskService aisTaskService, @NotNull BatchUpdateService batchUpdateService) {
        Intrinsics.checkParameterIsNotNull((Object)aisTaskScoreService, (String)"aisTaskScoreService");
        Intrinsics.checkParameterIsNotNull((Object)aisTaskService, (String)"aisTaskService");
        Intrinsics.checkParameterIsNotNull((Object)batchUpdateService, (String)"batchUpdateService");
        this.aisTaskScoreService = aisTaskScoreService;
        this.aisTaskService = aisTaskService;
        this.batchUpdateService = batchUpdateService;
    }

    public static final /* synthetic */ AisTaskScoreService access$getAisTaskScoreService$p(TaskScoreController $this) {
        return $this.aisTaskScoreService;
    }
}

