/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.ais.AisRole;
import aisexpert.backend.ais.AisRoleService;
import aisexpert.backend.ais.AisUser;
import aisexpert.backend.ais.AisUserService;
import aisexpert.backend.ais.RoleInfoCommand;
import aisexpert.backend.ais.UserInfoCommand;
import aisexpert.backend.ais.ZoneRight;
import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.repository.AuthTokenRepository;
import aisexpert.backend.web.UserAccessService;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0012J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0012J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016RS\u0010\t\u001aA\u0012*\u0012( \u000f*\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e0\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\n\u00a2\u0006\u0002\b\u0011X\u0092\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u000f*\u0004\u0018\u00010\u00170\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Laisexpert/backend/web/UserAccessService;", "", "authTokenRepository", "Laisexpert/backend/repository/AuthTokenRepository;", "aisUserService", "Laisexpert/backend/ais/AisUserService;", "aisRoleService", "Laisexpert/backend/ais/AisRoleService;", "(Laisexpert/backend/repository/AuthTokenRepository;Laisexpert/backend/ais/AisUserService;Laisexpert/backend/ais/AisRoleService;)V", "accessCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lkotlin/ParameterName;", "name", "accessToken", "kotlin.jvm.PlatformType", "Laisexpert/backend/web/UserAccessService$Access;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "accessCache$annotations", "()V", "emptyAccess", "fullAccess", "logger", "Lorg/slf4j/Logger;", "fetchAccess", "fetchAccessWrapper", "getAccess", "hasAdmin", "", "hasApply", "level", "Laisexpert/backend/ais/ZoneRight;", "hasLearn", "hasReports", "hasReportsFed", "hasSupervising", "Access", "aisexpert-backend"})
public class UserAccessService {
    private final Logger logger;
    private final LoadingCache<String, Access> accessCache;
    private final Access fullAccess;
    private final Access emptyAccess;
    private final AuthTokenRepository authTokenRepository;
    private final AisUserService aisUserService;
    private final AisRoleService aisRoleService;

    private static /* synthetic */ void accessCache$annotations() {
    }

    public boolean hasAdmin(@NotNull String accessToken) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        return this.getAccess(accessToken).getAdmin();
    }

    public boolean hasLearn(@NotNull String accessToken, @NotNull ZoneRight level) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        return this.getAccess(accessToken).getLearn().compareTo((Enum)level) >= 0;
    }

    public boolean hasApply(@NotNull String accessToken, @NotNull ZoneRight level) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        return this.getAccess(accessToken).getApply().compareTo((Enum)level) >= 0;
    }

    public boolean hasReports(@NotNull String accessToken, @NotNull ZoneRight level) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        return this.getAccess(accessToken).getReports().compareTo((Enum)level) >= 0;
    }

    public boolean hasReportsFed(@NotNull String accessToken, @NotNull ZoneRight level) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        return this.getAccess(accessToken).getReports().compareTo((Enum)level) >= 0;
    }

    public boolean hasSupervising(@NotNull String accessToken, @NotNull ZoneRight level) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        return this.getAccess(accessToken).getSupervising().compareTo((Enum)level) >= 0;
    }

    private Access getAccess(String accessToken) {
        Access access = (Access)this.accessCache.get((Object)accessToken);
        if (access == null) {
            access = this.emptyAccess;
        }
        return access;
    }

    private Access fetchAccess(String accessToken) {
        AuthToken authToken = this.authTokenRepository.findById((Object)accessToken).orElse(null);
        if (authToken == null) {
            return this.emptyAccess;
        }
        AuthToken token = authToken;
        if (Intrinsics.areEqual((Object)token.isAdmin(), (Object)true)) {
            return this.fullAccess;
        }
        AisUser userDto = this.aisUserService.userInfo(new UserInfoCommand(token.getUserId()));
        String string = userDto.getGroupId();
        if (string == null) {
            return this.emptyAccess;
        }
        String groupId = string;
        AisRole groupDto = this.aisRoleService.info(token.getHashId(), new RoleInfoCommand(groupId));
        return new Access(false, groupDto.getCanLearnModel(), groupDto.getCanApplyModel(), groupDto.getCanRWReport(), groupDto.getCanReportFed(), groupDto.getCanMonitoring());
    }

    private Access fetchAccessWrapper(String accessToken) {
        this.logger.info("Fetching access for token '" + accessToken + '\'');
        Access result = this.fetchAccess(accessToken);
        this.logger.info("Access = " + result);
        return result;
    }

    public UserAccessService(@NotNull AuthTokenRepository authTokenRepository, @NotNull AisUserService aisUserService, @NotNull AisRoleService aisRoleService) {
        Intrinsics.checkParameterIsNotNull((Object)authTokenRepository, (String)"authTokenRepository");
        Intrinsics.checkParameterIsNotNull((Object)aisUserService, (String)"aisUserService");
        Intrinsics.checkParameterIsNotNull((Object)aisRoleService, (String)"aisRoleService");
        this.authTokenRepository = authTokenRepository;
        this.aisUserService = aisUserService;
        this.aisRoleService = aisRoleService;
        this.logger = LoggerFactory.getLogger(UserAccessService.class);
        Function1 function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
        LoadingCache loadingCache = Caffeine.newBuilder().refreshAfterWrite(Duration.ofMinutes(10L)).build((CacheLoader)new sam.com_github_benmanes_caffeine_cache_CacheLoader.0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)loadingCache, (String)"Caffeine.newBuilder()\n  \u2026this::fetchAccessWrapper)");
        this.accessCache = loadingCache;
        this.fullAccess = new Access(true, ZoneRight.WRITE, ZoneRight.WRITE, ZoneRight.WRITE, ZoneRight.WRITE, ZoneRight.WRITE);
        this.emptyAccess = new Access(false, ZoneRight.NONE, ZoneRight.NONE, ZoneRight.NONE, ZoneRight.NONE, ZoneRight.NONE);
    }

    public static final /* synthetic */ Access access$fetchAccessWrapper(UserAccessService $this, String accessToken) {
        return $this.fetchAccessWrapper(accessToken);
    }
}

