/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.entity.AuthToken;
import aisexpert.backend.repository.AuthTokenRepository;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u0016\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0017R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Laisexpert/backend/web/UserActivityService;", "", "authTokenRepository", "Laisexpert/backend/repository/AuthTokenRepository;", "(Laisexpert/backend/repository/AuthTokenRepository;)V", "activeSecrets", "", "", "kotlin.jvm.PlatformType", "", "logger", "Lorg/slf4j/Logger;", "getLastActiveByUserId", "", "Ljava/time/OffsetDateTime;", "ids", "", "updateActivity", "", "updateActivityByTokenSecret", "secrets", "aisexpert-backend"})
public class UserActivityService {
    private final Logger logger;
    private final Set<String> activeSecrets;
    private final AuthTokenRepository authTokenRepository;

    @Transactional
    public void updateActivityByTokenSecret(@NotNull List<String> secrets2) {
        Intrinsics.checkParameterIsNotNull(secrets2, (String)"secrets");
        this.activeSecrets.addAll((Collection)secrets2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, OffsetDateTime> getLastActiveByUserId(@NotNull List<String> ids) {
        Object object;
        Map.Entry u;
        Object object2;
        Object k;
        Object k2;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        List tokens = this.authTokenRepository.findByUserIds(ids);
        Object $receiver$iv = tokens;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator<Object> iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object3;
            Object t = iterator.next();
            AuthToken t2 = (AuthToken)t;
            boolean bl = false;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            key$iv$iv = t2.getUserId();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(t);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            key$iv$iv = destination$iv$iv;
            k2 = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            k = k2;
            object2 = key$iv$iv;
            boolean bl2 = false;
            Iterable $i$f$getOrPut = $receiver$iv2 = (Iterable)u.getValue();
            Collection destination$iv$iv2 = new ArrayList();
            void $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            Iterator iterator2 = $receiver$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                OffsetDateTime offsetDateTime;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                AuthToken it = (AuthToken)element$iv$iv;
                boolean bl3 = false;
                if (it.getLastActive() == null) continue;
                OffsetDateTime it$iv$iv2 = offsetDateTime;
                destination$iv$iv2.add(it$iv$iv2);
            }
            object = (List)destination$iv$iv2;
            object2.put(k, object);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
            key$iv$iv = destination$iv$iv;
            k2 = it$iv$iv.getKey();
            u = (Map.Entry)element$iv$iv$iv;
            k = k2;
            object2 = key$iv$iv;
            boolean bl = false;
            object = (OffsetDateTime)CollectionsKt.max((Iterable)((Iterable)u.getValue()));
            object2.put(k, object);
        }
        $receiver$iv = destination$iv$iv;
        LinkedHashMap result$iv = new LinkedHashMap();
        Object object4 = $receiver$iv;
        for (Map.Entry entry : object4.entrySet()) {
            OffsetDateTime it = (OffsetDateTime)entry.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        return result$iv;
    }

    @Scheduled(fixedRate=60000L)
    public void updateActivity() {
        ArrayList secrets2 = new ArrayList(this.activeSecrets);
        this.activeSecrets.removeAll(secrets2);
        Collection collection = secrets2;
        if (!collection.isEmpty()) {
            this.logger.info("Flushing active tokens = " + secrets2);
            Iterable iterable = this.authTokenRepository.findAllById((Iterable)secrets2);
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"authTokenRepository.findAllById(secrets)");
            Iterable tokens = iterable;
            OffsetDateTime now = OffsetDateTime.now();
            for (AuthToken token : tokens) {
                token.setLastActive(now);
            }
            this.authTokenRepository.saveAll(tokens);
        }
    }

    public UserActivityService(@NotNull AuthTokenRepository authTokenRepository) {
        Intrinsics.checkParameterIsNotNull((Object)authTokenRepository, (String)"authTokenRepository");
        this.authTokenRepository = authTokenRepository;
        this.logger = LoggerFactory.getLogger(UserActivityService.class);
        this.activeSecrets = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

