/*
 * Decompiled with CFR 0.152.
 */
package aisexpert.backend.web;

import aisexpert.backend.utils.UtilsKt;
import aisexpert.backend.web.UserActivityService;
import aisexpert.backend.web.WebSocketUserActivityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.user.SimpSession;
import org.springframework.messaging.simp.user.SimpSubscription;
import org.springframework.messaging.simp.user.SimpSubscriptionMatcher;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0017R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Laisexpert/backend/web/WebSocketUserActivityService;", "", "userActivityService", "Laisexpert/backend/web/UserActivityService;", "userRegistry", "Lorg/springframework/messaging/simp/user/SimpUserRegistry;", "(Laisexpert/backend/web/UserActivityService;Lorg/springframework/messaging/simp/user/SimpUserRegistry;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "updateUserActivity", "", "aisexpert-backend"})
public class WebSocketUserActivityService {
    private final Logger logger;
    private final UserActivityService userActivityService;
    private final SimpUserRegistry userRegistry;

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedRate=60000L)
    public void updateUserActivity() {
        void $receiver$iv$iv;
        Set set = this.userRegistry.findSubscriptions((SimpSubscriptionMatcher)updateUserActivity.secrets.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"userRegistry\n           \u2026indSubscriptions { true }");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SimpSubscription simpSubscription = (SimpSubscription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            SimpSession simpSession = v1.getSession();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpSession, (String)"it.session");
            SimpUser simpUser = simpSession.getUser();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpUser, (String)"it.session.user");
            String string = simpUser.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.session.user.name");
            String string2 = UtilsKt.getSecret((String)string);
            collection.add(string2);
        }
        List secrets2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Collection collection = secrets2;
        if (!collection.isEmpty()) {
            this.logger.info("Active web socket tokens = " + secrets2);
            this.userActivityService.updateActivityByTokenSecret(secrets2);
        }
    }

    public WebSocketUserActivityService(@NotNull UserActivityService userActivityService, @NotNull SimpUserRegistry userRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)userActivityService, (String)"userActivityService");
        Intrinsics.checkParameterIsNotNull((Object)userRegistry, (String)"userRegistry");
        this.userActivityService = userActivityService;
        this.userRegistry = userRegistry;
        this.logger = LoggerFactory.getLogger(WebSocketUserActivityService.class);
    }
}

