import qbs
import qbs.File
import qbs.TextFile
import "qbs/imports/QbsUtl/qbsutl.js" as QbsUtl

Project {
    minimumQbsVersion: "1.12.0"
    qbsSearchPaths: ["qbs"]

    readonly property var projectVersion: projectProbe.projectVersion
    readonly property var databaseVersion: projectProbe.databaseVersion
    readonly property string projectGitRevision: projectProbe.projectGitRevision
    readonly property string windowsKitsPath: "c:/opt/WindowsKits/10/Lib/10.0.17763.0/um/x64"

    Probe {
        id: projectProbe
        property var projectVersion;
        property var databaseVersion;
        property string projectGitRevision;

        readonly property string projectBuildDirectory:  buildDirectory
        readonly property string projectSourceDirectory: sourceDirectory

        configure: {
            projectVersion = QbsUtl.getVersions(projectSourceDirectory + "/VERSION");
            projectGitRevision = QbsUtl.gitRevision(projectSourceDirectory);
            if (File.exists(projectBuildDirectory + "/package_build_info"))
                File.remove(projectBuildDirectory + "/package_build_info")

            var fileVersionDb = projectSourceDirectory + "/VERSION_DB";
            if (!File.exists(fileVersionDb))
                throw new Error(("File '{0}' not found").format(fileVersionDb));

            var file = new TextFile(fileVersionDb, TextFile.ReadOnly);
            try {
                databaseVersion = file.readLine().trim();
            }
            finally {
                file.close();
            }
        }
    }

    property var cppDefines: {
        var def = [
            //"__cplusplus=201103L",
            "VERSION_PROJECT=" + projectVersion[0],
            "VERSION_PROJECT_MAJOR=" + projectVersion[1],
            "VERSION_PROJECT_MINOR=" + projectVersion[2],
            "VERSION_PROJECT_PATCH=" + projectVersion[3],
            "VERSION_DATABASE=" + databaseVersion,
            "GIT_REVISION=\"" + projectGitRevision + "\"",
            "QDATASTREAM_VERSION=QDataStream::Qt_4_8",
            "BPROTOCOL_VERSION_LOW=0",
            "BPROTOCOL_VERSION_HIGH=0",
            "JSON_SERIALIZATION",
            "BPROTO_SERIALIZATION",
        ];

        if (qbs.buildVariant === "release")
            def.push("NDEBUG");

        if (qbs.targetOS.contains("windows")
            && qbs.toolchain && qbs.toolchain.contains("mingw"))
        {
            def.push("CONFIG_DIR=\"ProgramData/aisexpert/config\"");
            def.push("WINDOWS_ACTIVE_DIRECTORY");
        }
        else
        {
            def.push("CONFIG_DIR=\"/etc/aisexpert\"");
            def.push("WINDOWS_ACTIVE_DIRECTORY_LDAP");
        }

        return def;
    }

    property var cxxFlags: [
        //"-std=c++11",
        "-ggdb3",
        //"-Winline",
        "-Wall",
        "-Wextra",
        "-Wno-unused-parameter",
        "-Wno-variadic-macros",
    ]
    property string cxxLanguageVersion: "c++14"
}
