import qbs
import GccUtl

Product {
    type: "staticlibrary"

    name: "DmlcCore"
    targetName: "dmlc_core"

    Depends { name: "cpp" }

    cpp.archiverName: GccUtl.ar(cpp.toolchainPathPrefix)
    cpp.cxxFlags: project.cxxFlags.concat([
        "-fopenmp",
        "-Wno-inline",
    ])
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    cpp.defines: [
        "DMLC_FOPEN_64_PRESENT=1",
    ]

    property var exportIncludePaths: [
        "./xgboost/dmlc-core/include"
    ]
    cpp.systemIncludePaths: exportIncludePaths;

    files: [
        "xgboost/dmlc-core/src/data/*.cc",
        "xgboost/dmlc-core/src/data/*.h",
        "xgboost/dmlc-core/src/io/*.cc",
        "xgboost/dmlc-core/src/io/*.h",
        "xgboost/dmlc-core/src/*.cc",
    ]
    excludeFiles: [
        "xgboost/dmlc-core/src/io/hdfs_filesys.cc",
        "xgboost/dmlc-core/src/io/hdfs_filesys.h",
        "xgboost/dmlc-core/src/io/s3_filesys.cc",
        "xgboost/dmlc-core/src/io/s3_filesys.h",
        "xgboost/dmlc-core/src/io/azure_filesys.cc",
        "xgboost/dmlc-core/src/io/azure_filesys.h",
    ]

    Export {
        Depends { name: "cpp" }
        cpp.systemIncludePaths: product.exportIncludePaths
    }
}
