import qbs
import GccUtl

Product {
    type: "staticlibrary"

    name: "Rabit"
    targetName: "rabit"

    Depends { name: "cpp" }

    cpp.archiverName: GccUtl.ar(cpp.toolchainPathPrefix)
    cpp.cxxFlags: project.cxxFlags.concat([
        "-Wno-inline",
    ])
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    Properties {
        condition: qbs.targetOS.contains("windows")
                   && qbs.toolchain && qbs.toolchain.contains("mingw")

        cpp.defines: [
            "_WIN32_WINNT=0x0600",
        ]
    }

    property var exportIncludePaths: [
        "./xgboost/rabit/include",
        "./xgboost/dmlc-core/include"
    ]

    cpp.systemIncludePaths: exportIncludePaths;

    files: [
        "xgboost/rabit/src/*.cc",
        "xgboost/rabit/src/*.h",
    ]
    excludeFiles: [
        "xgboost/rabit/src/engine_mpi.cc",
    ]

    Export {
        Depends { name: "cpp" }
        cpp.systemIncludePaths: product.exportIncludePaths
    }
}
