import qbs
import GccUtl

Product {
    type: "staticlibrary"

    name: "XGBoost"
    targetName: "xgboost"

    Depends { name: "cpp" }
    Depends { name: "DmlcCore" }
    Depends { name: "Rabit" }

    cpp.archiverName: GccUtl.ar(cpp.toolchainPathPrefix)
    cpp.cxxFlags: project.cxxFlags.concat([
        "-fopenmp",
        "-Wno-inline",
        "-Wno-reorder",
        "-Wno-sign-compare",
        "-Wno-unused-variable",
    ])
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    property var exportIncludePaths: [
        "./xgboost/include"
    ]
    cpp.systemIncludePaths: exportIncludePaths;

    files: [
        "xgboost/src/c_api/*.cc",
        "xgboost/src/c_api/*.h",
        "xgboost/src/common/*.cc",
        "xgboost/src/common/*.h",
        "xgboost/src/data/*.cc",
        "xgboost/src/data/*.h",
        "xgboost/src/gbm/*.cc",
        "xgboost/src/gbm/*.h",
        "xgboost/src/linear/*.cc",
        "xgboost/src/linear/*.h",
        "xgboost/src/metric/*.cc",
        "xgboost/src/metric/*.h",
        "xgboost/src/objective/*.cc",
        "xgboost/src/objective/*.h",
        "xgboost/src/predictor/*.cc",
        "xgboost/src/predictor/*.h",
        "xgboost/src/tree/*.cc",
        "xgboost/src/tree/*.h",
        "xgboost/src/learner.cc",
        "xgboost/src/logging.cc",
    ]

    Export {
        Depends { name: "cpp" }
        cpp.systemIncludePaths: product.exportIncludePaths
    }
}
