import qbs
import QbsUtl
import ProbExt

Product {
    name: "AisExpert"
    targetName: "aisexpert"
    condition: true

    type: "application"
    destinationDirectory: "./bin"

    Depends { name: "cpp" }
    Depends { name: "cppstdlib" }
    Depends { name: "Commands" }
    Depends { name: "RapidJson" }
    Depends { name: "SharedLib" }
    Depends { name: "Yaml" }
    Depends { name: "lib.firebird" }
    Depends { name: "Qt"; submodules: ["core", "network", "sql", "xml"] }
    Depends { name: "DmlcCore" }
    Depends { name: "Rabit" }
    Depends { name: "XGBoost" }

    ProbExt.LibValidationProbe {
        id: libValidationProbe
        checkingLibs: [
            lib.firebird
        ]
    }

    cpp.defines: {
        var def = project.cppDefines;
        return def;
    }

    cpp.cxxFlags: project.cxxFlags
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    cpp.driverFlags: [
        "-fopenmp",
        //"--param", "inline-unit-growth=250",
        //"--param", "max-inline-insns-single=2000",
    ]

    cpp.includePaths: [
        "./",
        "../",
    ]

    cpp.systemIncludePaths: QbsUtl.concatPaths(
        Qt.core.cpp.includePaths,
        lib.firebird.includePath
    )

    cpp.rpaths: QbsUtl.concatPaths(
        cppstdlib.path,
        lib.firebird.libraryPath,
        "$ORIGIN/../lib"
    )

     cpp.libraryPaths: QbsUtl.concatPaths(
         lib.firebird.libraryPath
         //lib.caffe.libraryPath,
         //project.buildDirectory + "/lib",
         //"/usr/lib/x86_64-linux-gnu/hdf5/serial"
     )

    cpp.dynamicLibraries: {
        var libs = [
            "pthread",
        ].concat(lib.firebird.dynamicLibraries);

        return libs;
    }

    Properties {
        condition: qbs.targetOS.contains("windows")
                   && qbs.toolchain && qbs.toolchain.contains("mingw")

        cpp.staticLibraries: [
            project.windowsKitsPath + "/WS2_32.Lib"
        ]
    }

    files: {
        var f = [
            "database/connect.cpp",
            "database/connect.h",
            "database/firebird_driver.cpp",
            "database/firebird_driver.h",
            "database/settings.cpp",
            "database/settings.h",
            "database/sql_func.cpp",
            "database/sql_func.h",
            "database/sqlcachedresult.cpp",
            "database/sqlcachedresult.h",
            "monitoring/http_connector.cpp",
            "monitoring/http_connector.h",
            "monitoring/mail_smtp.cpp",
            "monitoring/mail_smtp.h",
            "monitoring/observer.cpp",
            "monitoring/observer.h",
            "monitoring/notifier.cpp",
            "monitoring/notifier.h",
            "tasks/base_task.cpp",
            "tasks/base_task.h",
            "tasks/create_report.cpp",
            "tasks/create_report.h",
            "tasks/create_report_fed.cpp",
            "tasks/create_report_fed.h",
            "tasks/learn_model.cpp",
            "tasks/learn_model.h",
            "tasks/report_fed.cpp",
            "tasks/report_fed.h",
            "tasks/ret_info.cpp",
            "tasks/ret_info.h",
            "tasks/scheduler.cpp",
            "tasks/scheduler.h",
            "tasks/score_calc.cpp",
            "tasks/score_calc.h",
            "tasks/sync_data.cpp",
            "tasks/sync_data.h",
            "tasks/sync_plan.cpp",
            "tasks/sync_plan.h",
            "tasks/sync_nsi.cpp",
            "tasks/sync_nsi.h",
            "tasks/send_score.cpp",
            "tasks/send_score.h",
            "tasks/sync_transfer.cpp",
            "tasks/sync_transfer.h",
            "tasks/task_messages.h",
            "tasks/utils.cpp",
            "tasks/utils.h",
            "aisexpert.cpp",
            "aisexpert_appl.cpp",
            "aisexpert_appl.h",
            "event_log.cpp",
            "event_log.h",
            "functions.cpp",
            "functions.h",
            "user_rights.cpp",
            "user_rights.h",
            "xgboost/options.cpp",
            "xgboost/options.h",
            "xgboost/autofree.cpp",
            "xgboost/autofree.h",
            "garbage_collector.cpp",
            "garbage_collector.h",
        ];

        if (qbs.targetOS.contains("linux")) {
            f = f.concat([
                "monitoring/system_info.cpp",
                "monitoring/system_info.h",
            ]);
        }

        return f;
    }

//    property var test: {
//        console.info("=== cpp.staticLibraries ===");
//        console.info(cpp.staticLibraries);
//        console.info("=== qbs.architecture ===");
//        console.info(qbs.architecture);
//        console.info("=== cpp.compilerLibraryPaths ===");
//        console.info(cpp.compilerLibraryPaths);
//        console.info("=== cpp.compilerPath ===");
//        console.info(cpp.compilerPath);
//        console.info("=== targetOS ===");
//        console.info(qbs.targetOS);
//        console.info("=== buildDirectory ===");
//        console.info(project.buildDirectory);
//    }

} // Product
