#pragma once

#include "functions.h"
#include "shared/qt/communication/func_invoker.h"
#include "shared/qt/communication/message.h"

#include <QtCore>
#include <QCoreApplication>
#include <atomic>
#include <chrono>

using namespace communication;
using namespace communication::transport;

class Application : public QCoreApplication
{
public:
    Application(int& argc, char** argv);

    bool init();
    void deinit();

    void initCheckConnect();

    static void stop() {_stop = true;}
    static bool isStopped() {return _stop;}

public slots:
    void stop(int exitCode);
    void message(const communication::Message::Ptr&);
    void messageTest(const communication::Message::Ptr&);

    void webSocketConnected(communication::SocketDescriptor);
    void webSocketDisconnected(communication::SocketDescriptor);

    void fomsSocketConnected(communication::SocketDescriptor);
    void fomsSocketDisconnected(communication::SocketDescriptor);

    void upoolSocketConnected(communication::SocketDescriptor);
    void upoolSocketDisconnected(communication::SocketDescriptor);

    void checkFomsConnect();
    void checkUpoolConnect();

private:
    Q_OBJECT
    void timerEvent(QTimerEvent* event) override;

    //--- Обработчики команд ---
    void command_UPoolAuthorization(const Message::Ptr&);
    void command_FomsAuthorization(const Message::Ptr&);
    void command_WebAuthorization(const Message::Ptr&);

    void command_UPoolChangesNotify(const Message::Ptr&);
    void command_UPoolUserAuth(const Message::Ptr&);

    void command_GroupCreate(const Message::Ptr&);
    void command_GroupEdit(const Message::Ptr&);
    void command_GroupDelete(const Message::Ptr&);
    void command_GroupInfo(const Message::Ptr&);
    void command_GroupList(const Message::Ptr&);
    void command_AssignGroup(const Message::Ptr&);

    void command_UserInfo(const Message::Ptr&);
    void command_UserList(const Message::Ptr&);
    void command_UserActiveStatus(const Message::Ptr&);
    void command_UserActiveSet(const Message::Ptr&);
    void command_UserResetAuth(const Message::Ptr&);
    void command_UserLogout(const Message::Ptr&);

    void command_ModelEdit(const Message::Ptr&);
    void command_ModelDelete(const Message::Ptr&);
    void command_ModelInfo(const Message::Ptr&);
    void command_ModelList(const Message::Ptr&);

    void command_Monitoring(const Message::Ptr&);
    void command_MonitorThresholdInfo(const Message::Ptr&);
    void command_MonitorThresholdEdit(const Message::Ptr&);

    void command_SendMailDebug(const Message::Ptr&);

    void command_NotifyAddressCreate(const Message::Ptr&);
    void command_NotifyAddressEdit(const Message::Ptr&);
    void command_NotifyAddressDelete(const Message::Ptr&);
    void command_NotifyAddressInfo(const Message::Ptr&);
    void command_NotifyAddressList(const Message::Ptr&);

    void command_NotifyTriggerCreate(const Message::Ptr&);
    void command_NotifyTriggerEdit(const Message::Ptr&);
    void command_NotifyTriggerDelete(const Message::Ptr&);
    void command_NotifyTriggerInfo(const Message::Ptr&);
    void command_NotifyTriggerList(const Message::Ptr&);

    void command_ScoreEdit(const Message::Ptr&);
    void command_ScoreDelete(const Message::Ptr&);
    void command_ScoreInfo(const Message::Ptr&);
    void command_ScoreList(const Message::Ptr&);

    void command_NeedSendScore(const Message::Ptr&);

    void command_NsiVidmpList(const Message::Ptr&);
    void command_NsiProfileList(const Message::Ptr&);
    void command_NsiLpuList(const Message::Ptr&);
    void command_NsiMkbList(const Message::Ptr&);

    void command_ModelXgbDelete(const Message::Ptr&);
    void command_ModelXgbInfo(const Message::Ptr&);
    void command_ModelXgbEdit(const Message::Ptr&);
    void command_ModelXgbOption(const Message::Ptr&);

    void command_SyncProgress(const Message::Ptr&);

    void command_EventLogList(const Message::Ptr&);
    void command_AisVersion(const Message::Ptr&);

    void validateUsers();
    void validateScores(const QUuidEx& modelId, QList<QUuidEx>& scores);

    void checkWebAuthorization();
    
private:
    static volatile bool _stop;
    static std::atomic_int _exitCode;

    int _stopTimerId = {-1};
    int _fomsConTimerId = {-1};
    int _upoolConTimerId = {-1};
    int _webAuthorizTimerId = {-1};
    int _configBaseTimerId = {-1};
    int _garbageTimerId = {-1};

    FunctionInvoker _funcInvoker;

    RouteCommands _upoolRoute;
    //RouteCommands _inputRoute;

    // Время последней модификации конфиг-файла
    std::time_t _configBaseModify = {0};

    // Время последней модификации конфиг-файла для логера
    std::time_t _configLoggerModify = {0};

    trd::ThreadIdList _threadIds;
};
