#include "settings.h"
#include "sql_func.h"

#include "shared/logger/logger.h"
#include "shared/qt/logger/logger_operators.h"

#define log_error_m   alog::logger().error  (__FILE__, __func__, __LINE__, "DbSettings")
#define log_warn_m    alog::logger().warn   (__FILE__, __func__, __LINE__, "DbSettings")
#define log_info_m    alog::logger().info   (__FILE__, __func__, __LINE__, "DbSettings")
#define log_verbose_m alog::logger().verbose(__FILE__, __func__, __LINE__, "DbSettings")
#define log_debug_m   alog::logger().debug  (__FILE__, __func__, __LINE__, "DbSettings")
#define log_debug2_m  alog::logger().debug2 (__FILE__, __func__, __LINE__, "DbSettings")

namespace db {
namespace settings {

using namespace db::firebird;

bool getValue(QSqlQuery& q, const QString& name, qint64& value)
{
    if (!sql::exec(q,
        "SELECT VALUE_INT FROM SETTINGS WHERE NAME = ?", name))
    {
        return false;
    }
    if (!q.first())
        return false;

    sql::assignValue(value, q.record(), "VALUE_INT" );
    return true;
}

bool getValue(QSqlQuery& q, const QString& name, quint64& value)
{
    qint64 v = 0;
    if (getValue(q, name, v))
    {
        value = *((quint64*) &v);
        return true;
    }
    return false;
}

bool getValue(QSqlQuery& q, const QString& name, double& value)
{
    if (!sql::exec(q,
        "SELECT VALUE_DOUBLE FROM SETTINGS WHERE NAME = ?", name))
    {
        return false;
    }
    if (!q.first())
        return false;

    sql::assignValue(value, q.record(), "VALUE_DOUBLE" );
    return true;
}

bool getValue(QSqlQuery& q, const QString& name, float& value)
{
    double d = 0;
    if (getValue(q, name, d))
    {
        value = static_cast<float>(d);
        return true;
    }
    return false;
}

bool getValue(QSqlQuery& q, const QString& name, QString& value)
{
    if (!sql::exec(q,
        "SELECT VALUE_STRING FROM SETTINGS WHERE NAME = ?", name))
    {
        return false;
    }
    if (!q.first())
        return false;

    sql::assignValue(value, q.record(), "VALUE_STRING" );
    return true;
}

bool setValue(QSqlQuery& q, const QString& name, qint64 value)
{
    return sql::exec(q, " UPDATE OR INSERT INTO SETTINGS                "
                        " (NAME, VALUE_INT, VALUE_STRING, VALUE_DOUBLE) "
                        " VALUES                                        "
                        " (?, ?, NULL, NULL)                            "
                        " MATCHING (NAME)                               ",
                        name, value);
}

bool setValue(QSqlQuery& q, const QString& name, quint64 value)
{
    qint64 v = *((qint64*) &value);
    return setValue(name, v);
}

bool setValue(QSqlQuery& q, const QString& name, double value)
{
    return sql::exec(q, " UPDATE OR INSERT INTO SETTINGS                "
                        " (NAME, VALUE_INT, VALUE_STRING, VALUE_DOUBLE) "
                        " VALUES                                        "
                        " (?, NULL, NULL, ?)                            "
                        " MATCHING (NAME)                               ",
                        name, value);
}

bool setValue(QSqlQuery& q, const QString& name, float value)
{
    double d = value;
    return setValue(name, d);
}

bool setValue(QSqlQuery& q, const QString& name, const QString& value)
{
    return sql::exec(q, " UPDATE OR INSERT INTO SETTINGS                "
                        " (NAME, VALUE_INT, VALUE_STRING, VALUE_DOUBLE) "
                        " VALUES                                        "
                        " (?, NULL, ?, NULL)                            "
                        " MATCHING (NAME)                               ",
                        name, value);
}

bool removeValue(const QString& name)
{
    db::firebird::Driver::Ptr dbcon = dbpool().connect();
    QSqlQuery q {dbcon->createResult()};
    return sql::exec(q, "DELETE FROM SETTINGS WHERE NAME = ?", name);
}

bool removeValue(QSqlQuery& q, const QString& name)
{
    return sql::exec(q, "DELETE FROM SETTINGS WHERE NAME = ?", name);
}

} // namespace settings
} // namespace db

#undef log_error_m
#undef log_warn_m
#undef log_info_m
#undef log_verbose_m
#undef log_debug_m
#undef log_debug2_m
