#pragma once

#include "connect.h"
#include <QtCore>
#include <QtSql>
#include <type_traits>

namespace db {
namespace settings {

template<typename T>
struct not_integral_type : std::enable_if<!std::is_integral<T>::value, int> {};
template<typename T>
struct is_integral_type : std::enable_if<std::is_integral<T>::value, int> {};


bool getValue(QSqlQuery& q, const QString& name, qint64&  value);
bool getValue(QSqlQuery& q, const QString& name, quint64& value);
bool getValue(QSqlQuery& q, const QString& name, double&  value);
bool getValue(QSqlQuery& q, const QString& name, float&   value);
bool getValue(QSqlQuery& q, const QString& name, QString& value);

template<typename T>
bool getValue(QSqlQuery& q, const QString& name, T& value,
              typename db::settings::is_integral_type<T>::type = 0)
{
    qint64 v = 0;
    if (getValue(q, name, v))
    {
        value = static_cast<T>(v);
        return true;
    }
    return false;
}

template<typename T>
bool getValue(const QString& name, T& value)
{
    db::firebird::Driver::Ptr dbcon = dbpool().connect();
    QSqlQuery q {dbcon->createResult()};

    return getValue(q, name, value);
}

bool setValue(QSqlQuery& q, const QString& name, qint64   value);
bool setValue(QSqlQuery& q, const QString& name, quint64  value);
bool setValue(QSqlQuery& q, const QString& name, double   value);
bool setValue(QSqlQuery& q, const QString& name, float    value);
bool setValue(QSqlQuery& q, const QString& name, const QString& value);

template<typename T>
bool setValue(QSqlQuery& q, const QString& name, T value,
              typename db::settings::is_integral_type<T>::type = 0)
{
    qint64 v = value;
    return setValue(q, name, v);
}

template<typename T>
bool setValue(const QString& name, T value)
{
    db::firebird::Driver::Ptr dbcon = dbpool().connect();
    QSqlQuery q {dbcon->createResult()};

    return setValue(q, name, value);
}

bool removeValue(const QString& name);
bool removeValue(QSqlQuery& q, const QString& name);

} // namespace settings
} // namespace db
