#pragma once
#include "database/connect.h"
#include "database/sql_func.h"
#include <QtCore>

namespace event_log
{

using namespace sql;

enum class Type : quint32
{
    System = 0,
    User = 1
};

template<typename T>
void log(Type type, T&& text)
{
    QSqlQuery q {maindb()->createResult()};

    if (!q.prepare(" INSERT INTO EVENT_LOG        "
                  " ( CREATEDATE, TYPE, TEXT )    "
                  " VALUES                        "
                  " ( :CREATEDATE, :TYPE, :TEXT ) "))
        return;

    bindValue(q, ":CREATEDATE" , QDateTime::currentDateTime() );
    bindValue(q, ":TYPE"     , type                           );
    bindValue(q, ":TEXT"     , text                           );

    q.exec();
}

template<typename T, typename U>
void log(Type type, T&& text, U&& value)
{
    text = text.arg(value);
    QSqlQuery q {maindb()->createResult()};

    if (!q.prepare(" INSERT INTO EVENT_LOG        "
                  " ( CREATEDATE, TYPE, TEXT )    "
                  " VALUES                        "
                  " ( :CREATEDATE, :TYPE, :TEXT ) "))
        return;

    bindValue(q, ":CREATEDATE" , QDateTime::currentDateTime() );
    bindValue(q, ":TYPE"     , type                           );
    bindValue(q, ":TEXT"     , text                           );

    q.exec();
}

template<typename T, typename U, typename... Args>
void log(Type type, T&& text, U&& value, Args&&... args)
{
    log(type, text.arg(value), args...);
}

} // namespace elogger
