#pragma once

#include "shared/defmac.h"
#include "shared/safe_singleton.h"
#include "shared/qt/thread/qthreadex.h"
#include <QtCore>

class GarbageCollector : public QThreadEx
{
private:
    GarbageCollector() = default;
    DISABLE_DEFAULT_COPY(GarbageCollector)

    bool collect();
    void run() override;
    void threadStopEstablished() override;

private:
    // Идентификатор потока
    pid_t _threadId = {0};

    template<typename T, int> friend T& ::safe_singleton();
};

GarbageCollector& garbageCollector();
