#pragma once

#include <QtCore>
#include <QtNetwork>
#include <QTcpSocket>
#include <QObject>
#include <QByteArray>

#include "shared/defmac.h"
#include "shared/safe_singleton.h"
#include "shared/qt/communication/message.h"

namespace monitoring {

class HttpConnector : public QTcpServer
{
public:
    bool init();
    void reinit();

private slots:
    void onReadyRead();
    void onDisconnected();

private:
    Q_OBJECT
    DISABLE_DEFAULT_COPY(HttpConnector)
    HttpConnector() = default;

    void incomingConnection(communication::SocketDescriptor handle) override;

    template<typename T, int> friend T& ::safe_singleton();
};

HttpConnector& httpConnector();

} // namespace monitoring
