#pragma once

#include "shared/defmac.h"
#include "shared/container_ptr.h"
#include "shared/safe_singleton.h"
#include "shared/qt/quuidex.h"
#include "shared/qt/thread/qthreadex.h"

#include <QtCore>

namespace monitoring {

class MailSmtp : public QThreadEx
{
public:
    struct MailData
    {
        typedef container_ptr<MailData> Ptr;

        QString triggerType;
        QUuidEx triggerId;
        QStringList addresses;
        QString subject;
        QString body;
    };

    bool init();

    // Пробуждение потока
    void awake();

    // Отправка сообщения
    void send(const MailSmtp::MailData::Ptr&);

private slots:
    // Обработчик сигнала QTcpSocket::disconnected()
    void socketDisconnected();

private:
    void run() override;
    void threadStopEstablished() override;

private:
    Q_OBJECT
    DISABLE_DEFAULT_COPY(MailSmtp)
    MailSmtp() = default;

    QMutex _threadLock;
    QWaitCondition _threadCond;

    QList<MailData::Ptr> _mailList;

    template<typename T, int> friend T& ::safe_singleton();
};

MailSmtp& mailSmtp();

} // namespace monitoring
