#pragma once

#include "commands/monitoring.h"
#ifdef __linux__
#include "monitoring/system_info.h"
#endif
#include "shared/defmac.h"
#include "shared/simple_timer.h"
#include "shared/qt/thread/qthreadex.h"
#include <QtCore>

namespace monitoring {

using namespace communication;

class Monitoring : public QThreadEx
{
public:
    Monitoring();
    ~Monitoring();

    bool init();
    data::Monitoring::Ptr get() const;

private:
    void run() override;
    void update();

private:
    Q_OBJECT
    DISABLE_DEFAULT_COPY(Monitoring)

    data::Monitoring::Ptr _monitoring {new data::Monitoring};
    mutable QMutex _monitoringLock;

#ifdef __linux__
    SystemInfo _systemInfo;
#endif

    data::MonitorSoftware _monitorSoftware;
    simple_timer _monitorSoftwareTimer;

};

} // namespace monitoring
