#pragma once

#include "shared/defmac.h"
#include "shared/safe_singleton.h"
#include "shared/qt/thread/qthreadex.h"
#include "shared/qt/communication/message.h"

#include <QtCore>

namespace monitoring {

using namespace communication;

class Notifier : public QThreadEx
{
public:
    bool init();

private:
    Q_OBJECT
    DISABLE_DEFAULT_COPY(Notifier)
    Notifier() = default;

    void run() override;
    void threadStopEstablished() override;

    void checkTrigger(const QString& triggerType, qint16 threshold);

    QStringList readAddresses(const QUuidEx& triggerId);
    void updateEmissionTime(qint16 emissionInterval, const QUuidEx& triggerId);
    QString getEvlogMessages();

    // Идентификатор потока
    pid_t _threadId = {0};

    template<typename T, int> friend T& ::safe_singleton();
};

Notifier& notifier();

} // namespace monitoring
