#include "observer.h"
#include "functions.h"
#include "commands/authorization.h"
//#include "commands/sync_data.h"
//#include "commands/send_score.h"
#include "commands/foms.h"
//#include "commands/task.h"
//#include "commands/commands.h"
#include "database/connect.h"
#include "database/sql_func.h"
#ifdef __linux__
#include "monitoring/system_info.h"
#endif
#include "shared/logger/logger.h"
#include "shared/qt/config/config.h"
#include "shared/qt/logger/logger_operators.h"

#define log_error_m   alog::logger().error  (__FILE__, __func__, __LINE__, "Observer")
#define log_warn_m    alog::logger().warn   (__FILE__, __func__, __LINE__, "Observer")
#define log_info_m    alog::logger().info   (__FILE__, __func__, __LINE__, "Observer")
#define log_verbose_m alog::logger().verbose(__FILE__, __func__, __LINE__, "Observer")
#define log_debug_m   alog::logger().debug  (__FILE__, __func__, __LINE__, "Observer")
#define log_debug2_m  alog::logger().debug2 (__FILE__, __func__, __LINE__, "Observer")

namespace monitoring {

using namespace communication::transport;
using namespace db::firebird;
using namespace sql;

Observer& observer()
{
    return ::safe_singleton<Observer>();
}

Observer::Observer()
{
    chk_connect_d(fomsCon().socket().get(), SIGNAL(message(communication::Message::Ptr)),
                  this, SLOT(message(communication::Message::Ptr)))
}

bool Observer::init()
{
    return true;
}

data::Monitoring::Ptr Observer::get() const
{
    QMutexLocker locker(&_threadLock); (void) locker;
    return _monitor;
}

void Observer::message(const communication::Message::Ptr& message)
{
    if (message->processed())
        return;

    if (message->command() == command::FomsEcho)
    {
        message->markAsProcessed();

        QMutexLocker locker(&_threadLock); (void) locker;
        _fomsEcho = message;
        _fomsEchoTimeout.reset();
    }
}

void Observer::fomsCommandProcessed(bool val)
{
    _fomsError = !val;
}

void Observer::run()
{
    log_info_m << "Started";

    _threadId = trd::gettid();

#ifdef __linux__
       SystemInfo systemInfo;
#endif
    simple_timer softwareTimer {-60 /*сек*/};

    while (true)
    {
        CHECK_QTHREADEX_STOP
        data::Monitoring::Ptr monitor {new data::Monitoring};

        bool emulationMode = false;
        config::base().getValue("monitoring.emulation.active", emulationMode);

        if (emulationMode)
        {
            monitor->hardware.cpu.system  = 20;
            monitor->hardware.cpu.process = 80;
            monitor->hardware.cpu.total   = 100;

            config::base().getValue("monitoring.emulation.hardware.cpu.system",  monitor->hardware.cpu.system);
            config::base().getValue("monitoring.emulation.hardware.cpu.process", monitor->hardware.cpu.process);
            config::base().getValue("monitoring.emulation.hardware.cpu.total",   monitor->hardware.cpu.total);

            monitor->hardware.ram.system  = 500;
            monitor->hardware.ram.process = 3200;
            monitor->hardware.ram.total   = 4000;

            config::base().getValue("monitoring.emulation.hardware.ram.system",  monitor->hardware.ram.system);
            config::base().getValue("monitoring.emulation.hardware.ram.process", monitor->hardware.ram.process);
            config::base().getValue("monitoring.emulation.hardware.ram.total",   monitor->hardware.ram.total);

            monitor->hardware.hdd.system  = 800;
            monitor->hardware.hdd.process = 4000;
            monitor->hardware.hdd.total   = 6000;

            config::base().getValue("monitoring.emulation.hardware.hdd.system",  monitor->hardware.hdd.system);
            config::base().getValue("monitoring.emulation.hardware.hdd.process", monitor->hardware.hdd.process);
            config::base().getValue("monitoring.emulation.hardware.hdd.total",   monitor->hardware.hdd.total);

            monitor->hardware.cpuMaxCoreTemp = 80;
            config::base().getValue("monitoring.emulation.hardware.cpu_max_core_temp", monitor->hardware.cpuMaxCoreTemp);


            monitor->software.inWork.modelCount  = 20;
            monitor->software.inWork.scoreCount  = 20;
            monitor->software.inWork.reportCount = 20;

            config::base().getValue("monitoring.emulation.software.in_work.model_count",  monitor->software.inWork.modelCount);
            config::base().getValue("monitoring.emulation.software.in_work.score_count",  monitor->software.inWork.scoreCount);
            config::base().getValue("monitoring.emulation.software.in_work.report_count", monitor->software.inWork.reportCount);

            monitor->software.inDeferred.modelCount  = 20;
            monitor->software.inDeferred.scoreCount  = 20;
            monitor->software.inDeferred.reportCount = 20;

            config::base().getValue("monitoring.emulation.software.in_deferred.model_count",  monitor->software.inDeferred.modelCount);
            config::base().getValue("monitoring.emulation.software.in_deferred.score_count",  monitor->software.inDeferred.scoreCount);
            config::base().getValue("monitoring.emulation.software.in_deferred.report_count", monitor->software.inDeferred.reportCount);

            monitor->software.errorCount = 20;
            config::base().getValue("monitoring.emulation.software.error_count", monitor->software.errorCount);

            monitor->software.fomsIsActive = true;
            config::base().getValue("monitoring.emulation.software.foms_active", monitor->software.fomsIsActive);

            { //Block for QMutexLocker
                QMutexLocker locker(&_threadLock); (void) locker;
                _monitor = monitor;
            }
            sleep(5);
            continue;
        } // if (emulationMode)

        if (fomsCon().isAuthorized())
        {
            Message::Ptr m = createJsonMessage(command::FomsEcho);
            fomsCon().send(m);
        }

#ifdef __linux__
        systemInfo.update(monitor->hardware);
#endif
        bool softwareIsUpdated = false;
        if (softwareTimer.elapsed() > 20*1000 /*20 сек*/)
        {
            db::firebird::Driver::Ptr dbcon = dbpool().connect();
            QSqlQuery q {dbcon->createResult()};
            sql::exec(q, " SELECT TASK_TYPE, EXEC_STATUS, COUNT(*) "
                         " FROM TASK GROUP BY TASK_TYPE, EXEC_STATUS");

            CHECK_QTHREADEX_STOP

            while (q.next())
            {
                QSqlRecord r = q.record();

                TaskType taskType {TaskType::Undefined};
                assignTaskT(taskType, r);

                TaskExecStatus execStatus {TaskExecStatus::NotRun};
                assignValue(execStatus, r, "EXEC_STATUS");

                quint32 taskCount = 0;
                assignValue(taskCount, r, "COUNT");

                if (taskType == TaskType::LearnModel)
                {
                    if (execStatus == TaskExecStatus::Running)
                        monitor->software.inWork.modelCount = taskCount;
                    else if (execStatus == TaskExecStatus::Deffered)
                        monitor->software.inDeferred.modelCount = taskCount;
                }
                else if (taskType == TaskType::ScoreCalc)
                {
                    if (execStatus == TaskExecStatus::Running)
                        monitor->software.inWork.scoreCount = taskCount;
                    else if (execStatus == TaskExecStatus::Deffered)
                        monitor->software.inDeferred.scoreCount = taskCount;
                }
                else if (taskType == TaskType::CreateReport)
                {
                    if (execStatus == TaskExecStatus::Running)
                        monitor->software.inWork.reportCount = taskCount;
                    else if (execStatus == TaskExecStatus::Deffered)
                        monitor->software.inDeferred.reportCount = taskCount;
                }
            }

            if (sql::exec(q,
                " SELECT COUNT(*) FROM EVENT_LOG "
                " WHERE TASK_ID IS NOT NULL AND "
                " TASK_LIFE = 0 AND TASK_RET_CODE > 0 AND "
                " CREATE_DATE > DATEADD (-1 DAY TO CURRENT_TIMESTAMP)"))
            {
                q.first();
                monitor->software.errorCount = q.value(0).toUInt();
            }
            softwareTimer.reset();
            softwareIsUpdated = true;
            CHECK_QTHREADEX_STOP
        } // if (softwareTimer.elapsed()...

        { //Block for QMutexLocker
            QMutexLocker locker(&_threadLock); (void) locker;
            if (!softwareIsUpdated)
                monitor->software = _monitor->software;

            _monitor = monitor;

            if (!fomsCon().isAuthorized()
                || _fomsEchoTimeout.elapsed() > 12*1000 /*12 сек*/)
            {
                _fomsEcho.reset();
            }

            _monitor->software.fomsIsActive = (_fomsEcho)
                ? _fomsEcho->execStatus() == Message::ExecStatus::Success
                : false;

            if (_fomsError)
                _monitor->software.fomsIsActive = false;

            //log_debug2_m << "_fomsEcho/_fomsError: "
            //             << _fomsEcho << "/" << _fomsError;
        }
        sleep(5);

    } // while (true)

    log_info_m << "Stopped";
}

void Observer::threadStopEstablished()
{
    dbpool().abortOperation(_threadId);
}

} // namespace monitoring

#undef log_error_m
#undef log_warn_m
#undef log_info_m
#undef log_verbose_m
#undef log_debug_m
#undef log_debug2_m
