#pragma once

#include "commands/monitor.h"
#include "shared/defmac.h"
#include "shared/simple_timer.h"
#include "shared/safe_singleton.h"
#include "shared/qt/thread/qthreadex.h"
#include "shared/qt/communication/message.h"

#include <QtCore>
#include <atomic>

namespace monitoring {

using namespace communication;

class Observer : public QThreadEx
{
public:
    bool init();
    data::Monitoring::Ptr get() const;

public slots:
    void message(const communication::Message::Ptr&);
    void fomsCommandProcessed(bool);

private:
    Q_OBJECT
    DISABLE_DEFAULT_COPY(Observer)
    Observer();

    void run() override;
    void threadStopEstablished() override;

private:
    Message::Ptr _fomsEcho;
    simple_timer _fomsEchoTimeout;
    std::atomic_bool _fomsError = {true};

    mutable QMutex _threadLock;
    data::Monitoring::Ptr _monitor {new data::Monitoring};

    // Идентификатор потока
    pid_t _threadId = {0};

    template<typename T, int> friend T& ::safe_singleton();
};

Observer& observer();

} // namespace monitoring
