#include "proces_stable.h"

#include "structures.h"
#include <sys/types.h>
#include <unistd.h>
//#include <iostream>

namespace monitoring {

ProcessTable::ProcessTable()
{
//    QTimer *timer = new QTimer;
//    connect(timer, SIGNAL(timeout()), this, SLOT(update()));
//    timer->start(4000);
}

void ProcessTable::update(data::Monitoring& monitoring)
{
    monitoring.PID = getpid();
    QFile data {"/proc/" + QString::number(monitoring.PID) + "/status"};
    data.open(QFile::ReadOnly);
    QTextStream stream(&data);
    QString s = stream.readAll();

    static QRegExp rx1 {R"(Name:\s+([A-z]+))"};
    static QRegExp rx2 {R"(VmRSS:\s+(\d+))"};
    static QRegExp rx3 {R"(Threads:\s+(\d+))"};

    auto regVal = [](const QString& s,  const QRegExp& rx) -> QString
    {
        int pos = rx.indexIn(s);
        return (pos != -1) ? rx.cap(1) : QString{};
    };

    monitoring.processName = regVal(s, rx1);  // getSubStrFromString(s, rx1);
    monitoring.ram.process = regVal(s, rx2).toUInt(); // getValueFromString (s, rx2);
    monitoring.nThreads    = regVal(s, rx3).toUInt(); // getValueFromString (s, rx3);
}

} // namespace monitoring
