#pragma once

#include "structures.h"
#include "commands/monitor.h"
#include <QtCore>

namespace monitoring {

using namespace std;
using namespace communication;

class SystemInfo
{
public:
    SystemInfo();
    void update(data::MonitorHardware&);

private:
    QVector<float>  readCpuStats();

    void readProcInfo   (data::MonitorHardware&);
    void readCpuInfo    (data::MonitorHardware&);
    void readMemoryInfo (data::MonitorHardware&);
    void readHddInfo    (data::MonitorHardware&);
    void readHostInfo();

    quint64  sizeFolder(const QString& path);
    double   cpuMaxTemp();
    quint32  cpuLoad();
    double   procLoad();
    QString  hostName();
    QString  userName();
    long     uptime();

private:
    struct PStat
    {
        unsigned long utime_ticks;
        unsigned long cutime_ticks;
        unsigned long stime_ticks;
        unsigned long cstime_ticks;
    };

    struct HostInformation
    {
        QString hostName;
        QString userName;
        long    uptime = {0};
    };

    static const QString _aisHome;

    QVector<float>    _cpuStatusPrev;
    QVector<float>    _cpuStatusNow;
    PStat             _pstatPrev;
    PStat             _pstatNow;

    quint32           _cpuTotalTime;
    HostInformation   _hostInfo;

    quint64           _sizeAisFolder;

};

} // namespace monitoring
