#include "notifier.h"

#include "QDebug"


namespace notifier {

//using namespace db::firebird;
//using namespace sql;

Notifier::Notifier()
{
#ifdef MINGW
        QString configFile = config::dir() + "/../state/aisexpert.state";
#else
        QString configFile = "/var/opt/aisexpert/state/aisexpert.state";
#endif
        config::state().read(configFile.toStdString());
}

bool Notifier::init()
{
    config::state().getValue("cpu.notify",  _settings.cpu.notify);
    config::state().getValue("cpu.warning", _settings.cpu.warning);
    config::state().getValue("cpu.alarm",   _settings.cpu.alarm);

    config::state().getValue("ram.notify",  _settings.ram.notify);
    config::state().getValue("ram.warning", _settings.ram.warning);
    config::state().getValue("ram.alarm",   _settings.ram.alarm);

    config::state().getValue("hdd.notify",  _settings.hdd.notify);
    config::state().getValue("hdd.warning", _settings.hdd.warning);
    config::state().getValue("hdd.alarm",   _settings.hdd.alarm);

    return true;
}

data::NotifierSettings Notifier::getSettings()
{
    return _settings;
}

bool Notifier::setSettings(data::NotifierSettings & settings)
{

    _settings = settings;
    saveSettings();
    return true;
}

//bool Notifier::mainNotifierSqlQuery(QSqlQuery &q, data::Notice &notice)
//{
//    // Общие поля, задаются при создании и редактировании задачи
//    QString fields =
//        "  ID             "
//        ", IS_ACTIVE      "
//        ", NAME           "
//        ", SUBJECT        "
//        ", NOTICE_LEVEL   "
//        ", DESCRIPTION    "
//        ", EMAIL_ADDRESS  "
//        ", MESSEGE        "
//        ;

//    // UPDATE OR INSERT INTO ...
//    QString sql =
//        sql::UPDATE_OR_INSERT_INTO("NOTICES", fields, "ID");

//    if (!q.prepare(sql))
//        return false;

//    bindValue(q, ":ID             ", notice.id           );
//    bindValue(q, ":IS_ACTIVE      ", notice.isActive     );
//    bindValue(q, ":NAME           ", notice.name         );
//    bindValue(q, ":SUBJECT        ", notice.subject      );
//    bindValue(q, ":NOTICE_LEVEL   ", notice.level        );
//    bindValue(q, ":DESCRIPTION    ", notice.description  );
//    bindValue(q, ":EMAIL_ADDRESS  ", notice.addresses    );
//    bindValue(q, ":MESSEGE        ", notice.message      );

////    qDebug() << notice.id;

//    return q.exec();
//}

void Notifier::saveSettings()
{
    config::state().setValue("cpu.notify",  _settings.cpu.notify);
    config::state().setValue("cpu.warning", _settings.cpu.warning);
    config::state().setValue("cpu.alarm",   _settings.cpu.alarm);

    config::state().setValue("ram.notify",  _settings.ram.notify);
    config::state().setValue("ram.warning", _settings.ram.warning);
    config::state().setValue("ram.alarm",   _settings.ram.alarm);

    config::state().setValue("hdd.notify",  _settings.hdd.notify);
    config::state().setValue("hdd.warning", _settings.hdd.warning);
    config::state().setValue("hdd.alarm",   _settings.hdd.alarm);

    config::state().save();
}

} // namespace notifier
