#pragma once

#include "base_task.h"
#include "commands/report.h"

#include <QtCore>
#include <QSqlQuery>

namespace task {

class CreateReport : public BaseTaskThread
{
public:
    CreateReport(const QUuidEx& taskId, const QUuidEx& userId);

private:
    Q_OBJECT
    DISABLE_DEFAULT_FUNC(CreateReport)

    void run() override;
    void sanitize() override;
    const QUuidEx& contentId() const override;

private:
    data::Report _report;
};

} // namespace task
