#pragma once

#include "base_task.h"
#include "commands/report_fed.h"

#include <QtCore>
#include <QSqlQuery>

namespace task {

class CreateReportFed : public BaseTaskThread
{
public:
    CreateReportFed(const QUuidEx& taskId, const QUuidEx& userId);

private:
    Q_OBJECT
    DISABLE_DEFAULT_FUNC(CreateReportFed)

    void run() override;
    void threadStopEstablished() override;

    void sanitize() override;
    const QUuidEx& contentId() const override;

private:
    data::ReportFed _report;
};

} // namespace task
