#include "tasks/ret_info.h"

namespace task
{

const RetInfo::SuccessType RetInfo::Success;

RetInfo::RetInfo(SuccessType) : RetInfo(Error::None)
{}

RetInfo::RetInfo(Error error)
{
    _d->error = error;
    _d->critical = (error == Error::None) ? Critical::No : Critical::Yes;
}

RetInfo::RetInfo(Error error, Critical critical)
{
    _d->error = error;
    _d->critical = critical;
}

RetInfo::RetInfo(RetInfo&& r)
{
    _d = r._d;
}

RetInfo& RetInfo::operator= (RetInfo&& r)
{
    _d = r._d;
    return *this;
}

bool RetInfo::operator== (const RetInfo& r) const
{
    return (_d->error == r._d->error) && (_d->critical == r._d->critical);
}

} // namespace task
