#pragma once

#include "base_task.h"
#include "tasks/utils.h"
#include "database/firebird_driver.h"

namespace task {

using namespace communication;

/**
  Задача по вычислению оценок на основе модели
*/
class ScoreCalc : public BaseTaskThread
{
public:
    ScoreCalc(const QUuidEx& taskId, const QUuidEx& userId);

private:
    Q_OBJECT
    DISABLE_DEFAULT_FUNC(ScoreCalc)

    void run() override;
    const QUuidEx& contentId() const override;

    /**
      @brief Инициализация задачи
      @return RetInfo - с информацие об ошибке
    */
    RetInfo initPeriod() override;

    /**
      @brief Создание оценок в БД
      @return RetInfo - с информацие об ошибке
    */
    RetInfo insertScore();

    /**
      @brief Заполнить массив data данными из таблицы
      @param data - массив для записи данных из таблицы
      @return 0 если выполнение без ошибок, код ошибки в противном случае.
    */
    RetInfo fillArrays(Ret2DArray& data, ScoreType type);

    /**
      @brief Метод применяет модель для заданного диапазона данных. Тип модели
             задаётся переменной "type"
      @return RetInfo - с информацие об ошибке
    */
    RetInfo makeApply(ScoreType type);

    /**
      @brief Загрузка сохраненных настроек для модели
      @param options - список, куда будут помещены настройки.
      @return true - в случае успешной загрузки, false - иначе.
    */

    bool loadXgbOptions(QMap<QString, QString>& options);
    /**
      @brief Действия, которые производит метод в случае досрочного выхода при
             возникновении ошибки.
    */
    void sanitize() override;

    // Идентификатор созданных оценок
    QUuidEx _scoreId = {QUuidEx::createUuid()};

    // Идентификатор модели, которая используется при вычислении оценок
    QUuidEx _baseModelId;

    // Идентификатор задачи обучения, которая является родительской для данной
    // задачи оценок
    QUuidEx _baseTaskId;

    // Фактическая левая и правая  граница диапазона, с которой работает задача обучения
    //TimeRange _periodReal;

    bool   _binaryDump;

    // Элемент вектора номер N указывает на строку данных в массиве, который
    // был заполнен методом fillArrays.
    QVector<QUuidEx> _rowIndexer;
};

} // namespace task
