#pragma once

#include "sync_transfer.h"
#include "commands/time_range.h"
#include "database/firebird_driver.h"
#include "shared/simple_timer.h"

namespace task {

using namespace communication;
using namespace db::firebird;

class SendScore : public SyncTransfer
{
public:
    bool init();

private:
    Q_OBJECT
    DISABLE_DEFAULT_COPY(SendScore)
    SendScore();

    void run() override;

    /**
      @brief Отправка скоров, с идентификатором _scoreId
      @return
    */
    bool sendScore();

    // Вычисление контрольной суммы и количества строк полученных от ФОМС
    // сервера
    bool calcCrc(Transaction::Ptr transact, quint64& crc, quint64& count);

    bool sendCrcStatus(bool status);

private:
    // Параметры текущего скора
    QUuidEx   _scoreId;
    QString   _scoreName;
    QString   _scoreDescr;
    QDateTime _createDate;
    TimeRange _scorePeriod;

    QUuidEx   _modelId;
    QString   _modelName;
    QString   _modelDescr;
    TimeRange _modelPeriod;

    QUuidEx   _userId;
    QString   _userName;

    // Количество строк данных на отправку
    quint32 _sendSize = {50*1000};

    template<typename T, int> friend T& ::safe_singleton();
};

SendScore& sendScore();

} // namespace task
