#pragma once

#include "base_task.h"
#include "sync_transfer.h"
#include "database/firebird_driver.h"

namespace task {

class SyncNsi : public SyncTransfer, public BaseTask
{
public:
    SyncNsi(const QUuidEx& taskId, const QUuidEx& userId);

private:
    DISABLE_DEFAULT_FUNC(SyncNsi)

    void run() override;
    void interrupt() override;

    bool taskIsRunning() override;
    bool taskIsFinished() override;

    void taskStart() override;
    bool taskStop(unsigned long timeout) override;
    void taskTerminate() override;

    RetInfo syncVidmp(db::firebird::Transaction::Ptr);
    RetInfo syncProfile(db::firebird::Transaction::Ptr);
    RetInfo syncLpu(db::firebird::Transaction::Ptr);
    RetInfo syncMkb(db::firebird::Transaction::Ptr);

};

} // namespace task
