#pragma once
#include "event_log.h"

#define TASK_EVENT_LOG(MSG, ...) \
    EventLog(MSG, ##__VA_ARGS__) << EventTask(this->id(), this->retCode(), true) \
                                 << EventUser(this->userId())

#define TASK_EVENT_LOG2(MSG, ...) \
    EventLog(MSG, ##__VA_ARGS__) << EventTask(task->id(), task->retCode(), true) \
                                 << EventUser(task->userId())

// Выводим последнее сообщение с задержкой в 1 миллисекунду, что бы БД сообщения
// отображались в правильном порядке
#define TASK_CLEAN_AND_RETURN(TASK_NAME) { \
    sanitize(); \
    usleep(1000 /*1 миллисекунда*/); \
    log_error_m << EventLog(TASK_IS_COMPLETED, TASK_NAME) \
                << EventTask(this->id(), this->retCode(), false) \
                << EventUser(this->userId()); \
    return; }

#define TASK_COMPLETE(TASK_NAME) { \
    usleep(1000); \
    log_info_m << EventLog(TASK_IS_COMPLETED2, TASK_NAME) \
               << EventTask(this->id(), this->retCode(), false) \
               << EventUser(this->userId()); \
    }

#define TASK_RETURN_FOR_SYNC(TASK_NAME) { \
    sanitize(); \
    usleep(1000); \
    log_info_m << EventLog(TASK_IS_COMPLETED3, TASK_NAME) \
               << EventTask(this->id(), this->retCode(), false) \
               << EventUser(this->userId()); \
    return; }

#define TASK_RETURN_FOR_INT(TASK_NAME) { \
    sanitize(); \
    usleep(1000); \
    if (interrupted()) { \
        log_info_m << EventLog(TASK_MSG_INT_USER, TASK_NAME) \
                   << EventTask(this->id(), this->retCode(), false) \
                   << EventUser(this->userId()); \
    } \
    else { \
        log_error_m << EventLog(TASK_MSG_INT, TASK_NAME) \
                    << EventTask(this->id(), this->retCode(), false) \
                    << EventUser(this->userId()); \
    } \
    return; }

#define TASK_CHECK_NEEDSYNC_AND_ERROR(TASK_NAME, ERROR_TEXT, ...) \
    if (_retInfo.correspond(RetInfo::Error::NeedSync)) { \
        TASK_RETURN_FOR_SYNC(TASK_NAME) \
    } \
    else if (!_retInfo) { \
        log_error_m << TASK_EVENT_LOG(ERROR_TEXT, ##__VA_ARGS__); \
        TASK_CLEAN_AND_RETURN(TASK_NAME); \
    }

#define TASK_CHECK_INT_AND_ERROR(TASK_NAME, ERROR_TEXT, ...) \
    if (_retInfo.correspond(RetInfo::Error::Interrupt) || interrupted()) { \
        TASK_RETURN_FOR_INT(TASK_NAME) \
    } \
    else if (!_retInfo) { \
        log_error_m << TASK_EVENT_LOG(ERROR_TEXT, ##__VA_ARGS__); \
        TASK_CLEAN_AND_RETURN(TASK_NAME); \
    }

/*
#define TASK_RETURN_FOR_NOROWS(TASK_NAME, ERROR_TEXT, SCORE_TYPE) \
    { \
        log_error_m << TASK_EVENT_LOG(ERROR_TEXT, SCORE_TYPE); \
        TASK_CLEAN_AND_RETURN(TASK_NAME); \
    }
*/

#define TASK_START               u8"Старт задачи '%1'"
#define DICTIONARY_START         u8"Процедура создания промежуточных данных начата"
#define DICTIONARY_STOP          u8"Процедура создания промежуточных данных завершена"
#define DATA_QUALITY_START       u8"Проверка качества входных данных начата"
#define DATA_QUALITY_STOP        u8"Проверка качества входных данных завершена"
#define TASK_IS_COMPLETED        u8"Задача '%1' завершена"
#define TASK_IS_COMPLETED2       u8"Задача '%1' завершена успешно"
#define TASK_IS_COMPLETED3       u8"Задача '%1' приостановлена (требуется синхронизация)"

#define TASK_ERR_SQL_BEGIN       u8"Ошибка старта SQL транзакции"
#define TASK_ERR_SQL_COMMIT      u8"Ошибка подтверждения SQL транзакции"
#define TASK_ERR_SQL_ROLLBACK    u8"Ошибка отмены SQL транзакции"
#define TASK_ERR_SQL_PREPARE     u8"Ошибка подготовки SQL запроса"
#define TASK_ERR_SQL_EXEC        u8"Ошибка выполнения SQL запроса"
#define TASK_ERR_SQL_INSERT      u8"Ошибка вставки записи ('%1')"
#define TASK_ERR_SQL_EMPTY       u8"SQL запрос вернул пустой набор данных"
#define TASK_ERR_INIT            u8"Ошибка инициализации задачи"
#define TASK_ERR_DATA_CHECK      u8"Ошибка проверки данных для задачи"
#define TASK_ERR_DATA_FMERA      u8"Ошибка проверки данных для расчета F-меры"
#define TASK_ERR_INIT_INFO       u8"Ошибка инициализации параметров задачи '%1'"
#define TASK_ERR_UNHANDLED       u8"Необработанная ошибка в задаче %1. Детали: %2"

#define TASK_ERR_NO_DATA         u8"Отсутствуют данные для обучения"
#define TASK_ERR_NO_CALC_DATA    u8"Отсутствуют данные для обучения по %1"
#define TASK_ERR_NODATA_SATURATE u8"Недостаточно данных для корректного обучения по %1 (записей с данными: %2; всего записей: %3)"
#define TASK_ERR_NODATA_ENOUGH   u8"Недостаточно размеченных данных для корректного обучения по %1 (период: %2, размеченных строк: %3)"
#define TASK_ERR_NODATA_FMERA    u8"Недостаточно размеченных данных для корректного расчета F-меры %1 (период: %2, размеченных строк: %3)"
#define TASK_ERR_BAD_RATIO       u8"Соотношение размеченных данных %1 имеет отклонение (с дефектом: %2%, без дефекта: %3%)"
#define TASK_ERR_LEARN_MEE       u8"Ошибка обучения МЭЭ"
#define TASK_ERR_LEARN_EKMP      u8"Ошибка обучения ЭКМП"
#define TASK_ERR_APPLY_MEE       u8"Ошибка применения МЭЭ"
#define TASK_ERR_APPLY_EKMP      u8"Ошибка применения ЭКМП"
#define TASK_ERR_MODEL_SAVE      u8"Ошибка сохранения модели"
#define TASK_ERR_SCORE_SAVE      u8"Ошибка сохранения оценок"
#define TASK_ERR_REC_COUNT       u8"Размера буфера данных некорректен"
#define TASK_ERR_FUNC_CALL       u8"Ошибка вызова функции %1"
#define TASK_ERR_FUNC_CALL2      u8"Ошибка вызова функции %1. RetCode: %2"
#define TASK_ERR_NO_FOMS         u8"Соединение с ФОМС сервером отсутствует"
#define TASK_ERR_NO_ANSWER       u8"Ответ от ФОМС сервера не получен"
#define TASK_ERR_ANSWER_TIMEOUT  u8"Превышен интервал ожидания ответа от ФОМС сервера для команды: %1, идентификатор %2"
#define TASK_ERR_ANSWER_ID       u8"ФОМС сервер вернул ответ с неверным идентификатором. Ожидалось: %1. Получено: %2"
#define TASK_ERR_ANSWER_COMMAND  u8"ФОМС сервер вернул ответ на другую команду. Ожидалось: %1. Получено: %2"
#define TASK_ERR_ANSWER_TYPE     u8"ФОМС сервер вернул ответ неверного типа для команды %1, идентификатор %2. Ожидался тип 'Answer'"
#define TASK_ERR_ANSWER_FAILED   u8"Произошла ошибка на стороне ФОМС сервера. Детали: %1"
#define TASK_ERR_ANSWER_PARSER   u8"Ошибка разбора json-выражения полученного от ФОМС сервера"
#define TASK_ERR_REG_SYNC        u8"Ошибка синхронизации данных регулярной задачи"
#define TASK_ERR_SYNC            u8"Ошибка синхронизации данных для задачи"
#define TASK_ERR_SYNC_DB         u8"Ошибка записи полученных данных"
#define TASK_ERR_SYNC_ROW_COUNT  u8"Неверное количество строк данных синхронизации"
#define TASK_ERR_CALC_FMERA      u8"Ошибка при вычислении F-меры для %1"

#define TASK_ERR_NSI_SYNC        u8"Ошибка синхронизации НСИ справочника '%1'"

#define TASK_MSG_NODATA          u8"Запрос не вернул данные"
//#define TASK_MSG_NOROWS          u8"Запрос не вернул данные (%1)"
#define TASK_MSG_NOMODEL         u8"Модель для обучения не найдена"
#define TASK_MSG_REG_NOTASK      u8"Отсутствует регулярная задача обучения"
#define TASK_MSG_REG_NOMODEL     u8"Отсутствуют модели, созданные задачей '%1'"
#define TASK_MSG_REG_NOSCORE     u8"Отсутствуют оценки, созданные задачей '%1'"
#define TASK_MSG_INT             u8"Выполнение задачи '%1' прервано"
#define TASK_MSG_INT_USER        u8"Выполнение задачи '%1' прервано пользователем"
#define TASK_MSG_RESTART         u8"Задача синхронизации перезапущена"
#define TASK_MSG_BREAK           u8"Получено сообщение о прерывании обмена"
#define TASK_MSG_SYNC_INFO       u8"Задача '%1' отложена до выполнения синхронизации"
#define TASK_MSG_F1_MEASURE      u8"Значение F-меры для %1: %2, порог %3"
#define TASK_MSG_SYNC_DAY        u8"Синхронизация дня %1"
#define TASK_MSG_SYNC_MONTH      u8"Синхронизация периода %1 / %2"

#define TASK_NAME_SYNCDATA       u8"Регулярная синхронизация данных"
#define TASK_NAME_SYNCNSI        u8"Регулярная синхронизации справочников НСИ"
#define TASK_NAME_REPORTFED      u8"Регулярное создание отчета ФФОМС"
#define TASK_NAME_LEARN          u8"Регулярная задача обучения"
#define TASK_NAME_APPLY          u8"Регулярная задача применения"
