#include "utils.h"

namespace task {

float toFloat(const QSqlRecord& rec, const QString& fieldName)
{
    QSqlField field = rec.field(fieldName.trimmed());

    if (field.isNull() || !field.isValid())
        return 0;

    if (field.value().userType() == QVariant::String)
    {
        QString str = field.value().toString();
        float tmp = str.toFloat();
        tmp = round(tmp*100000.0)/100000.0;
        return tmp;
    }

    if (field.value().userType() == QVariant::Double)
    {
        float d = field.value().toFloat();
        d = round(d*100000.0)/100000.0;
        return d;
    }

    if (field.value().userType() == QVariant::Int)
    {
        float d = field.value().toFloat();
        d = round(d*100000.0)/100000.0;
        return d;
    }

    if (field.value().userType() == QVariant::LongLong)
    {
        float d = field.value().toFloat();
        d = round(d*100000.0)/100000.0;
        return d;
    }

    // Если оказались здесь, сообщить Егорову Владимиру
    break_point

    return 0;
}

QVariant toVarchar(const QString& val)
{
    if (val != "" && val != "NA" && val != "None")
        return QVariant(val);
    else
        return QVariant(QVariant::String);
}

QVariant toVarchar(const qint32 val)
{
    return QVariant(val);
}

QVariant toSmallint(const QString& val)
{
    if (val != "" && val != "NA" && val != "None")
        return QVariant(val);
    else
        return QVariant(QVariant::Int);
}

QVariant toSmallint(const qint32 val)
{
    return QVariant((qint16)val);
}

QVariant toDate(const QString& val)
{
    if (val != "" && val != "NA" && val != "None")
        return QVariant(val);
    else
        return QVariant(QVariant::Date);
}

QVariant toDate(const qint32 val)
{
    qint64 value = qint64(val) * 1000;
    QDate date = QDateTime::fromMSecsSinceEpoch(value).date();

    if (val == 0)
        return QVariant(QVariant::Date);

    return QVariant(date);
}

QVariant toDouble(const QString& val)
{
    if (val != "" && val != "NA" && val != "None")
        return QVariant(val);
    else
        return QVariant(QVariant::Double);
}

QVariant toDouble(const double val)
{
    return QVariant(val);
}

QVariant toBigint(const QString& val)
{
    if (val != "" && val != "NA" && val != "None")
        return QVariant(val);
    else
        return QVariant(QVariant::LongLong);
}

QDateTime dateOnly(const QDateTime& date)
{
    return QDateTime(QDate(date.date()));
}

QDate firstDay(const QDateTime& date)
{
    QDate d = date.date();
    return QDate(d.year(), d.month(), 1);
}

QDate lastDay(const QDateTime& date)
{
    QDate d = date.date();
    return QDate(d.year(), d.month(), d.daysInMonth());
}

} // namespace task
