#pragma once
#include "database/sql_func.h"

namespace task {

class Ret2DArray
{
public:
    void alloc(int row, int col) {
        free();
        _rows = row;
        _columns = col;
        _array = new float[row * col];
    }
    void free() {
        if (_array) delete[] _array;
        _array = 0;
    }

    float* ptr() const {return _array;}

    int rows() const {return _rows;}
    int columns() const {return _columns;}

    ~Ret2DArray() {free();}

private:
    float* _array   = {0};
    int    _rows    = {0};
    int    _columns = {57}; //58
};

float toFloat(const QSqlRecord&, const QString& fieldName);

QVariant toVarchar(const QString& val);
QVariant toVarchar(const qint32 val);

QVariant toSmallint(const QString& val);
QVariant toSmallint(const qint32 val);

QVariant toDate(const QString& val);
QVariant toDate(const qint32 val);

QVariant toDouble(const QString& val);
QVariant toDouble(const double val);

QVariant toBigint(const QString& val);

/**
  @brief Отсечение времени от даты указанной в параметре
  @param date - дата
  @return
*/
QDateTime dateOnly(const QDateTime& date);

/**
  @brief Возврат первого дня месяца от даты указанной в параметре
  @param date - дата
  @return
*/
QDate firstDay(const QDateTime& date);

/**
  @brief Возврат последнего дня месяца от даты указанной в параметре
  @param date - дата
  @return
*/
QDate lastDay(const QDateTime& date);

} // namespace task
