/*****************************************************************************
  Модуль для работы с правами пользователя

*****************************************************************************/

#pragma once

#include "shared/list.h"
#include "shared/defmac.h"
#include "shared/clife_base.h"
#include "shared/clife_ptr.h"
#include "shared/clife_alloc.h"
#include "shared/safe_singleton.h"
#include "shared/qt/qhashex.h"
#include "shared/qt/quuidex.h"

#include <QtCore>
#include <QSqlRecord>


class UserRight
{
public:
    enum class Level
    {
        Disable = 0,
        Read    = 1,
        Write   = 2
    };

    enum class Permission
    {
        LearnModel = 0,
        ApplyModel = 1,
        Reports    = 2,
        Monitoring = 3
    };

    bool init();

    bool isAdmin(quint64 userHashId) const;
    bool isAdmin(const QUuidEx& userId) const;
    bool isWebAppl(quint64 userHashId) const;
    bool checkPermission(quint64 userHashId, Permission, Level) const;

    bool updatePermissions();
    bool updatePermissions(quint64 userHashId);

    quint64 webHashId() const;
    void setWebHashId(quint64);

    QUuidEx userId   (quint64 userHashId) const;
    QString userLogin(quint64 userHashId) const;
    QString userName (quint64 userHashId) const;

    QString userLogin(const QUuidEx& userId) const;
    QString userName (const QUuidEx& userId) const;

private:
    UserRight() = default;
    DISABLE_DEFAULT_COPY(UserRight)

    struct User
    {
        struct Compare
        {
            int operator() (const User* item1, const User* item2, void*) const
                {return LIST_COMPARE_ITEM(item1->hashId, item2->hashId);}

            int operator() (const quint64* hashId, const User* item2, void*) const
                {return LIST_COMPARE_ITEM(*hashId, item2->hashId);}
        };
        typedef lst::List<User, Compare> List;

        QUuidEx id;
        quint64 hashId = {0};
        QString login;
        QString name;
        bool    isAdmin = {false};
        bool    isActive = {false};
        QHashEx<Permission, Level> permissions;
    };

    void assignPermiss(User*, const QSqlRecord&);
    Level permissLevel(short);

    User::List _users;
    mutable QMutex _lock;

    quint64 _webHashId = {0};

    template<typename T, int> friend T& ::safe_singleton();
};

UserRight& uright();
uint qHash(UserRight::Permission type);
